package coins.backend.tmd;

import java.io.*;
import coins.backend.tmd.cs.*;

public class Main {

  static void usage() {
    System.out.println(
      "Usage: java Main  .../coins.backend.tmd [tmdfile foo.lir]");
  }

  public static void main(String[] argv) throws IOException {

    if (argv.length <= 1) {
      // % java coins.backend.tmd.Main
      // $B%F%9%HMQ%H%C%W%l%Y%k%k!<%W$KF~$k!#(B
      String main = argv.length == 0 ? "main.cs" : argv[0];
      InitFun.load(main, true);
      Eval.readEvalPrintLoop();
    }
    else if (argv.length == 2) {
      // % java coins.backend.tmd.Main foo.tmd bar.lir
      // TMD $B%/%i%97PM3$N%F%9%H!#(B bar.lir $B$N:G=i$N(B L $B4X?t$K$D$$$F(B
      // instsel $B$r<B9T!#(B
      
      String tmdfile = argv[0];
      String lirfile = argv[1];
	
      TMD tmd = new TMD(tmdfile);
      
      String lfunc =
	LibFun.toString(List.assq(Symbol.intern("FUNCTION"),
				  (List)
				  List.cddr((List)LibLisp.readf(lirfile))));
      
      lfunc = tmd.instsel(lfunc);
      
      System.out.println(lfunc);
    }
    else
      usage();
  }
}
