// (c) Copyright Taiichi Yuasa, 2002.  All rights reserved.

package coins.backend.tmd.cs;

public final class Contin extends RuntimeException implements Function {

  private boolean canCall = true;

  public String toString() {
    return "#<continuation>";
  }

  private static Object value;

  static {
    Subr.def("Contin", "callcc", "call/cc", 1);
    Subr.def("Contin", "callcc", "call-with-current-continuation", 1);
  }
  public static Object callcc(Function fun) {
    Contin cont = new Contin();
    try {
      return fun.invoke1(cont);
    } catch (Contin c) {
      if (c == cont)
        return value;
      else
        throw c;
    } finally {
      cont.canCall = false;
    }
  }

  public Object invoke(List args) {
    if (args == List.nil)
      throw Eval.error("too few arguments to continuation");
    else if (args.cdr != List.nil)
      throw Eval.error("too many arguments to continuation");

    if (canCall) {
      value = args.car;
      throw this;
    } else
      throw Eval.error("no continuation receiver");
  }

  public Object invoke1(Object arg) {
    if (canCall) {
      value = arg;
      throw this;
    } else
      throw Eval.error("no continuation receiver");
  }

  public boolean isSpecialForm() {
    return false;
  }

  static void init() {}

  static void clean() {
    value = null;
  }
}
