// 

package coins.backend.tmd;

import java.io.*;
import coins.backend.tmd.cs.*;


class LibFun {
  static void fatalError(String s) {
    RuntimeException e = new RuntimeException(s);
    e.printStackTrace();
    throw e;
  }
  static void fatalError(Throwable s) {
    fatalError(s.toString());
  }

  static Symbol makeSymbol(String name) {
    return Symbol.intern(name);
  }
  static Symbol makeSymbol(String name, Symbol key, Object val) {
    Symbol s = makeSymbol(name);
    Symbol.put(s, key, val);
    return s;
  }
  static Symbol makeSymbol(String name, String key, Object val) {
    Symbol s = makeSymbol(name);
    Symbol.put(s, makeSymbol(key), val);
    return s;
  }

  static Symbol makeVariable(String name, Object val) {
    return Symbol.makeOrdinary(name,val);
  }
  static Symbol makeVariable(String name) {
    return Symbol.makeOrdinary(name,List.nil);
  }


  static Pair list(Object x1) {
    return List.cons(x1,List.nil);
  }
  static Pair list(Object x1, Object x2) {
    return List.cons(x1,list(x2));
  }
  static Pair list(Object x1, Object x2, Object x3) {
    return List.cons(x1,list(x2,x3));
  }
  static Pair list(Object x1, Object x2, Object x3, Object x4) {
    return List.cons(x1,list(x2,x3,x4));
  }
  static Pair list(Object x1, Object x2, Object x3, Object x4, Object x5) {
    return List.cons(x1,list(x2,x3,x4,x5));
  }

  static Pair listA(Object x1, Object x2) {
    return List.cons(x1,x2);
  }
  static Pair listA(Object x1, Object x2, Object x3) {
    return List.cons(x1,listA(x2,x3));
  }
  static Pair listA(Object x1, Object x2, Object x3, Object x4) {
    return List.cons(x1,listA(x2,x3,x4));
  }

  public static int length(List x) {
    int len = 0;
    for (; x != List.nil; x = (List)x.cdr) len++;
    return len;
  }

  private static Symbol tosym(Object x) {
    if (x instanceof Symbol) return (Symbol)x;
    if (x instanceof String) return Symbol.intern((String)x);
    return tosym(x.toString());
  }

  static Object funcall(Object f, Object x1) {
    return tosym(f).functionOf().invoke(list(x1));
  }
  static Object funcall(Object f, Object x1, Object x2) {
    return tosym(f).functionOf().invoke(list(x1,x2));
  }
  static Object funcall(Object f, Object x1, Object x2, Object x3) {
    return tosym(f).functionOf().invoke(list(x1,x2,x3));
  }
  static Object funcall(Object f, Object x1, Object x2, Object x3,
			       Object x4) {
    return tosym(f).functionOf().invoke(list(x1,x2,x3,x4));
  }

  static String toString(Object exp) {
    StringWriter sm = new StringWriter();
    try {
      IO.write(exp, sm);
    } catch (IOException e) {}
    return sm.toString();
  }


  // $B?tCM1i;;4X78!#(B

  static Number add(Number x, Number y) {
    return Num.add(LibFun.list(x,y));
  }

  static Number add1(Number x) {
    return Num.onePlus(x);
  }

  static Number sub(Number x, Number y) {
    return Num.minus(x, LibFun.list(y));
  }

  static Number mul(Number x, Number y) {
    return Num.mult(LibFun.list(x,y));
  }

  static Number div(Number x, Number y) {
    return Num.div(x, LibFun.list(y));
  }

  static Number mod(Number x, Number y) {
    return Num.modulo(x, y);
  }

  static Number band(Number x, Number y) {
    return Num.logand(LibFun.list(x, y));
  }

  static Number bor(Number x, Number y) {
    return Num.logior(LibFun.list(x, y));
  }

  static Number bxor(Number x, Number y) {
    return Num.logxor(LibFun.list(x, y));
  }

  static Number bnot(Number x) {
    return Num.lognot(x);
  }

  static Number lsh(Number x, Number y) {
    return Num.logshl(x, y.intValue());
  }

  static Number rsh(Number x, Number y) {
    return Num.logshr(x, y.intValue());
  }

  static boolean eq(Number x, Number y) {return Num.compare(x, y)==0;}
  static boolean ne(Number x, Number y) {return Num.compare(x, y)!=0;}
  static boolean lt(Number x, Number y) {return Num.compare(x, y)<0;}
  static boolean gt(Number x, Number y) {return Num.compare(x, y)>0;}
  static boolean le(Number x, Number y) {return Num.compare(x, y)<=0;}
  static boolean ge(Number x, Number y) {return Num.compare(x, y)>=0;}
}
