// (c) Copyright Taiichi Yuasa, 2002.  All rights reserved.

final class Lambda implements Function {

  private Object params;
  private List body;
  private Env env;
  private Symbol name;

  Lambda(Symbol name, Env env, Object params, List body) {
    this.params = params;
    this.body = body;
    this.env = env;
    this.name = name;
  }

  void nameIt(Symbol sym) {
    if (name == null)
      name = sym;
  }

  static { Subr.defSpecial("Lambda", "lambda", 1, 0, true); }
  public static Lambda lambda(Object params, List body, Env env) {
    return new Lambda(null, env, params, body);
  }

  private final static Symbol Slambda = Symbol.intern("lambda");
  private final static Pair listLambda = List.list(Slambda);

  public Object invoke(List args) {
    try {
      return Eval.evalBody(body, Env.lambdaBind(params, args, env));
    } catch (Contin c) {
      throw c;
    } catch (Throwable e) {
      if (e != Eval.backtraceToken) {
        IO.println(Eval.errorMessage(e));
        IO.print("Backtrace: " + (name == null ? Slambda : name));
      } else
        IO.print(" < " + (name == null ? Slambda : name));
      throw Eval.backtraceToken;
    }
  }

  public Object invoke1(Object arg) {
    return invoke(new Pair(arg, List.nil));
  }

  public boolean isSpecialForm() {
    return false;
  }

  public String toString() {
    if (name == null)
      return "#<function>";
    else
      return "#<function " + name + ">";
  }

  static void init() {}
}
