// -*- mode: jde; c-basic-offset: 2 -*-
// update: Wed Jun 18 11:05:09 JST 2003
package coins.hir2lir;

import coins.*;
import coins.ir.*;
import coins.ir.hir.*;
import coins.ir.lir.*;
import coins.sym.*;
import java.util.*;
import java.io.*;
// import java.lang.*;

import coins.backend.Keyword;
import coins.backend.Op;
import coins.backend.util.*;

/**
 * Convert HIR into LIRv2.
 *  Output is written to specified stream in S-expression like form
 *  rather than memory.
 */
public class ConvToNewLIR {
  private File fSourceFile;
  // private PrintStream fOut;
  private HirRoot fHirRoot;

  private int tempCtr = 1;
  private String returnVarName = null;
  private String functionVarName = null;
  private ImList autoSym = null;
  private ImList symtab = null;

  private Map symNumbers = new HashMap();
  private java.util.Set appearedLabels = new HashSet();

  // todo: read tmd ?
  private static final QuotedString CSEG = new QuotedString("text");
  private static final QuotedString DSEG = new QuotedString("data");
  private static final String ZERO = "0".intern();
  private static final QuotedString _EPILOGUE = new QuotedString("_epilogue");

  private ArrayList Lseq;
  private ArrayList Lbody;	// { Ldata | Lfunc }
  private ArrayList DZSSeq;	// { DataSeq | ZeroSeq | SpaceSeq }
  private ArrayList numSeq;	// { Fixnum | Flonum | Lexp }
  private Type numSeqType;	// Ltype of numSeq (Vector only)

  private boolean returnUsed;


  /**
   * Construct ConvToNewLIR instance (singleton).
   *
   * @param pOut PrintStream object on which S-form LIR written.
   * @return the object created
   */
  public ConvToNewLIR(File pSourceFile, OutputStream pOut, HirRoot pHirRoot) {
    fSourceFile = pSourceFile;
    // fOut = new PrintStream(pOut);
    fHirRoot = pHirRoot;
  }
  
  /** Generate ImList from internal ArrayList */
  private ImList toImList(ArrayList l) {
    ImList tmp = ImList.Empty; {
      int max = l.size() - 1;
      for (int i = max; i >= 0 ; i--) {
	tmp = prefix(l.get(i), tmp);
      }
    }
    return tmp;
  }

  /** Returns quoted representaion of s */
  private QuotedString quote(String s) {
    return new QuotedString(s);
  }
  /* Returns unique name of Sym */
  private QuotedString uniqName(Sym pSym) {
    Integer varnum = (Integer) symNumbers.get(pSym);
    if (varnum != null) {
      return quote(varnum + "@" + pSym.getName());
    }
    return quote(pSym.getName());
  }

  /* Returns operator name defined by Op class */
  private String opName(int op) {
    return Op.toName(op).intern();
  }
  private ImList prefix(Object x, ImList y) {
    return new ImList(x, y);
  }
  private ImList prefix(Object x, Object y, ImList z) {
    return new ImList(x, new ImList(y, z));
  }
  private ImList prefix(Object x, Object y, Object z, ImList w) {
    return new ImList(x, new ImList(y, new ImList(z, w)));
  }
  private ImList prefix(Object x, Object y, Object z, Object w, ImList u) {
    return new ImList(x, new ImList(y, new ImList(z, new ImList(w, u))));
  }
  private ImList prefix(Object x, Object y, Object z, Object w, Object u, ImList v) {
    return new ImList(x, new ImList(y, new ImList(z, new ImList(w, new ImList(u, v)))));
  }
  private ImList list(Object x) {
    return new ImList(x, ImList.Empty);
  }
  private ImList list(Object x, Object y) {
    return new ImList(x, new ImList(y, ImList.Empty));
  }
  private ImList list(Object x, Object y, Object z) {
    return new ImList(x, new ImList(y, new ImList(z, ImList.Empty)));
  }
  private ImList list(Object x, Object y, Object z, Object w) {
    return new ImList(x, new ImList(y, new ImList(z, new ImList(w, ImList.Empty))));
  }
  private ImList list(Object x, Object y, Object z, Object w, Object u) {
    return new ImList(x, new ImList(y, new ImList(z, new ImList(w, new ImList(u, ImList.Empty)))));
  }
  private ImList list(Object x, Object y, Object z, Object w, Object u, Object v) {
    return new ImList(x, new ImList(y, new ImList(z, new ImList(w, new ImList(u, new ImList(v, ImList.Empty))))));
  }

  /** Add s to Lexp */
  private void addLexp(ImList s) {
    if (s != null) {
      Lseq.add(s);
    }
  }
  /** Add s to Lbody */
  private void addLbody(ImList s) {
    if (s != null) {
      Lbody.add(s);
    }
  }

  /**
   * Convert HIR to LIR
   * @param pProg HIR (must be Program object: why HIR?)
   */
  public ImList doConvert(HIR pProg) {
    ImList root = ImList.Empty;

    // Convert global symbols
    symtab = ImList.Empty;

    SymIterator symit = ((Program)pProg).getSymTable().getSymIterator();
    while (symit.hasNext()) {
      Sym sym = symit.next();
      String type, linkage;
      QuotedString segment;

      switch (sym.getSymKind()) {
      case Sym.KIND_VAR:
        // assert(sym instanceof VAR);
        // assert(((Var)sym).getStorageClass() == Var.VAR_STATIC);
        type = htype2ltype(sym.getSymType());
        segment = DSEG;
        break;
      case Sym.KIND_SUBP:
        type = Keyword.UNKNOWN;
        segment = CSEG;
		
        break;
      default:
        continue;
      }
      linkage = Keyword.LDEF;
      if (sym instanceof Var) {
        switch (((Var)sym).getVisibility()) {
        case Sym.SYM_PUBLIC: linkage = Keyword.XDEF; break;
        case Sym.SYM_EXTERN: linkage = Keyword.XREF; break;
        }
      } else if (sym instanceof Subp) {
        switch (((Subp)sym).getVisibility()) {
        case Sym.SYM_PUBLIC: linkage = Keyword.XDEF; break;
        case Sym.SYM_EXTERN: linkage = Keyword.XREF; break;
        }
      }

      String align = String.valueOf(sym.getSymKind() == Sym.KIND_SUBP ? 4 : sym.getSymType().getAlignment());

      ImList tmp = list(quote(sym.getName()), Keyword.STATIC, type, align,
			segment, linkage);
      symtab = new ImList(tmp, symtab);
    }

    Lbody = new ArrayList();

    // Fri May  9 20:57:23 JST 2003 by ak
    // initiation
    {
      HIR initPart = (HIR) ((Program)pProg).getInitiationPart();
      if (initPart != null && initPart instanceof BlockStmt) {
	Stmt tmp = ((BlockStmt) initPart).getFirstStmt();
	if (tmp != null) {
	  addLbody(convertNode(tmp));
	}
      }
    }

    // Generate functions
    ListIterator subpit = ((Program)pProg).getSubpDefinitionList().iterator();
    while (subpit.hasNext()) {
      SubpDefinition subp = (SubpDefinition)subpit.next();
      ImList tmp = convertSubpDef(subp);
      addLbody(tmp);
      // subs = prefix(tmp, subs);
      //System.out.println("subp: " + tmp);
      // Generate initiation after static var numbering.
      HIR initPart = (HIR) subp.getInitiationPart();
      /* todo: $B%A%'%C%/(B */
      if (initPart != null && initPart instanceof BlockStmt) {
	Stmt st = ((BlockStmt) initPart).getFirstStmt();
	convertNode(st);
      }
    }

    // Close symtab
    if (symtab != ImList.Empty) {
      symtab = new ImList(Keyword.SYMTAB, symtab);
      //System.out.println("sym: " + symtab);
    }

    ImList subs = toImList(Lbody);
    if (symtab != ImList.Empty) {
      subs = prefix(symtab, subs);
    }
    // root = prefix(Keyword.MODULE, quote(fSourceFile.getName()), symtab, subs);
    root = prefix(Keyword.MODULE, quote(fSourceFile.getName()), subs);
    //System.out.println("lir: " + root);
    return root;
  }

  // Return subprogram's symbol entry
  private Sym subpSymbol(SubpDefinition pSubp)
  {
    HIR p = pSubp;
    for (; p != null; p = (HIR)p.getParent()) {
      if (p.getOperator() == HIR.OP_SUBP_DEF)
        return ((SubpDefinition)p).getSubpSym();
    }
    return null;
  }
    
  // Convert a subprogram
  private ImList convertSubpDef(SubpDefinition pSubp)
  {
    Subp funSym = (Subp)subpSymbol(pSubp);
    Type retType = ((SubpType)funSym.getSymType()).getReturnType();

    // Write local static symbols to global symbol table
    SymNestIterator symit = pSubp.getSymTable().getSymNestIterator();
    while (symit.hasNext()) {
      Sym sym = symit.next();
      String type;
      if (sym.getSymKind() == Sym.KIND_VAR
	  && ((Var)sym).getStorageClass() == Var.VAR_STATIC) {
        type = htype2ltype(sym.getSymType());
	numberingSym(sym);
	ImList tmp = staticEnt(uniqName(sym), 
			       type,
			       String.valueOf(sym.getSymType().getAlignment()),
			       DSEG, 
			       Keyword.LDEF);
	symtab = prefix(tmp, symtab);
      }
    }
    // Write local automatic symbols
    autoSym = ImList.Empty;
    symit = pSubp.getSymTable().getSymNestIterator();
    while (symit.hasNext()) {
      Sym sym = symit.next();
      String store, type;
	
      switch (sym.getSymKind()) {
      case Sym.KIND_PARAM:
      case Sym.KIND_VAR:
        // assert(sym instanceof VAR);
        if (((Var)sym).getStorageClass() == Var.VAR_AUTO)
          store = Keyword.FRAME;
        else if (((Var)sym).getStorageClass() == Var.VAR_REGISTER)
          store = Keyword.REG;
        else // Maybe static
          continue;
        type = htype2ltype(sym.getSymType());
        break;
      default:
        continue;
      }
      numberingSym(sym);
      ImList tmp = list(uniqName(sym), store, type,
			String.valueOf(sym.getSymType().getAlignment()),
			ZERO);
      autoSym = prefix(tmp, autoSym);
    }

    // Prepare temporary variable for the value returned
    if (retType.getTypeKind() != Type.KIND_VOID) {
      returnVarName = String.valueOf(tempCtr++) + "@returnvalue";
      ImList tmp = frameEnt(returnVarName,
			    htype2ltype(retType), 
			    String.valueOf(retType.getAlignment()),
			    ZERO);
      autoSym = prefix(tmp, autoSym);
    }
    

    Lseq = new ArrayList();

    // Generate Prologue
    {
      ImList prologue = ImList.Empty; 
      
      
      ListIterator params = funSym.getParamList().iterator();
      while (params.hasNext()) {
	Param param = (Param)params.next();
	if (param == null)
	  break;
	ImList tmp = memExp(htype2ltype(param.getSymType()),
			    frameExp(hkind2ltype(Type.KIND_ADDRESS), uniqName(param)));
	prologue = prefix(tmp, prologue);
      }
      prologue = prefix(opName(Op.PROLOGUE),
			list("0", "0"),
			prologue.destructiveReverse());
      addLexp(prologue);
    }

    /* Mon May 26 18:02:28 JST 2003, delete old inititaion by ak*/
    // Main Program Initialization
    /* Tue May 13 11:09:31 JST 2003 by ak */
    // Generate Initialization
    /* Tue May 13 11:09:31 JST 2003 by ak */

    // Convert body
    returnUsed = false;
    convertNode(pSubp.getHirBody());

    // Generate Epilogue
    {
      ImList epilogue = ImList.Empty;
      addLexp(list(opName(Op.DEFLABEL), _EPILOGUE));
      if (retType.getTypeKind() != Type.KIND_VOID && returnUsed) {
	epilogue = list(memExp(htype2ltype(retType),
			       frameExp(htype2ltype(retType), returnVarName)));
      }
      epilogue = prefix(opName(Op.EPILOGUE),
			list(ZERO, ZERO),
			epilogue);
      addLexp(epilogue);
    }

    // Close local SYMTAB
    if (autoSym != ImList.Empty) {
      autoSym = prefix(Keyword.SYMTAB, autoSym);
    }
    ImList body = toImList(Lseq);
    if (autoSym != ImList.Empty) {
      // output local symtab
      body = prefix(autoSym, body);
    }
    return prefix(Keyword.FUNCTION, quote(funSym.getName()), body);
  }

  // Convert statement/expression node
  private ImList convertNode(HIR pHir) {
    ImList tmp = convertNode1(pHir, false);
    //System.out.println("node: " + tmp);
    return tmp; 
  }

  private ImList convertLvalue(HIR pHir) { return convertNode1(pHir, true);  }

  private ImList convertNode1(HIR pHir, boolean pIsLvalue) {
    ImList result = ImList.Empty;

    while (pHir != null) {
      Type type = pHir.getType();
      String ltype = htype2ltype(type);
      boolean isVolatile = type.isVolatile();

      switch (pHir.getOperator()) {
        // Expressions
      case HIR.OP_PARAM:
      case HIR.OP_VAR:
        {
          Sym sym = ((SymNode)pHir).getSymNodeSym();
          String store;
          Integer varnum = (Integer)symNumbers.get(sym);

          if (pIsLvalue) {
            if (((Var)sym).getStorageClass() == Var.VAR_STATIC)
              store = opName(Op.STATIC);
            else
              store = opName(Op.FRAME);
	    result = list(store, hkind2ltype(Type.KIND_ADDRESS), uniqName(sym));
          } else {
            ImList tmp = convertLvalue(pHir);
	    if (isVolatile) {
	      result = memExp(ltype, tmp, "&V");
	    } else {
	      result = memExp(ltype, tmp);
	    }
          }
        }
        return result;

      case HIR.OP_SUBP:
        {
          Sym sym = ((SymNode)pHir).getSymNodeSym();
	  result = staticExp(sym.getName());
        }
        return result;

      case HIR.OP_CONST:
        {
          Sym sym = ((ConstNode)pHir).getConstSym();
	  //System.out.println("csym: " + sym);
          if (sym.getSymKind() == Type.KIND_STRING_CONST) {
	    if (pIsLvalue) {
	      Integer varnum = (Integer)symNumbers.get(sym);
	      if (varnum == null) { // not installed.
		// install to symtab
		ImList tmp = staticEnt(numberingSym(sym) + "@string",
				       htype2ltype(sym.getSymType()),
				       String.valueOf(sym.getSymType().getAlignment()),
				       CSEG,
				       Keyword.LDEF);
		symtab = new ImList(tmp, symtab);
		varnum = (Integer)symNumbers.get(sym);
		//System.out.println("add: " + tmp + " = " + ((StringConst)sym).getStringBody());
		// generate (DATA ...)
		addLbody(strConst(varnum + "@string", ((StringConst)sym).getStringBody()));
	      }
	      result = staticExp(varnum + "@string");
	    } else {
	      String s = ((ConstNode)pHir).getConstSym().getName();
	      result = charSeq(s.substring(1, s.length() -1) /* de-quote */);
	    }
          } else if (type.isFloating()) {
	    result = floatConst(ltype, ((ConstNode)pHir).getConstSym().getName());
          } else {
	    result = intConst(ltype, ((ConstNode)pHir).getConstSym().getName());
          }
        }
        return result;

      case HIR.OP_ADD:     return convertBinop(pHir, opName(Op.ADD));
      case HIR.OP_SUB:     return convertBinop(pHir, opName(Op.SUB));

      case HIR.OP_INDEX:
      case HIR.OP_MULT:
        return convertBinop(pHir, opName(Op.MUL));

      case HIR.OP_DIV:
        return convertBinop(pHir, type.isUnsigned() ? opName(Op.DIVU) : opName(Op.DIVS));
      case HIR.OP_MOD:
        return convertBinop(pHir, type.isUnsigned() ? opName(Op.MODU) : opName(Op.MODS));
      case HIR.OP_NEG:     return convertUnaop(pHir, opName(Op.NEG));
      case HIR.OP_NOT:     return convertUnaop(pHir, opName(Op.BNOT));
      case HIR.OP_AND:     return convertBinop(pHir, opName(Op.BAND));
      case HIR.OP_OR:	   return convertBinop(pHir, opName(Op.BOR));
      case HIR.OP_XOR:     return convertBinop(pHir, opName(Op.BXOR));
        //        case HIR.OP_SHIFT_L: convertBinop(pHir, "LSHS"); return;
      case HIR.OP_SHIFT_R: return convertBinop(pHir, opName(Op.RSHS));
      case HIR.OP_SHIFT_LL: return convertBinop(pHir, opName(Op.LSHU));
      case HIR.OP_SHIFT_RL: return convertBinop(pHir, opName(Op.RSHU));
		
      case HIR.OP_CMP_EQ:     return convertBinop(pHir, opName(Op.TSTEQ));
      case HIR.OP_CMP_NE:     return convertBinop(pHir, opName(Op.TSTNE));
      case HIR.OP_CMP_GT:
        return convertBinop(pHir, type.isUnsigned() ? opName(Op.TSTGTU) : opName(Op.TSTGTS));
      case HIR.OP_CMP_GE:
        return convertBinop(pHir, type.isUnsigned() ? opName(Op.TSTGEU) : opName(Op.TSTGES));
      case HIR.OP_CMP_LT:
        return convertBinop(pHir, type.isUnsigned() ? opName(Op.TSTLTU) : opName(Op.TSTLTS));
      case HIR.OP_CMP_LE:
        return convertBinop(pHir, type.isUnsigned() ? opName(Op.TSTLEU) : opName(Op.TSTLES));

      case HIR.OP_CONV:
        {
          Type srcType = ((HIR)pHir.getChild1()).getType();
          if (srcType.isFloating()) {
            if (type.isFloating()) {
              // float to float
              if (srcType.getSizeValue() > type.getSizeValue())
                result = convertUnaop(pHir, opName(Op.CONVFT));
              else
                result = convertUnaop(pHir, opName(Op.CONVFX));
	    } // else
	    result = convertUnaop(pHir, opName(Op.CONVFI));
          } else {
            if (type.isFloating()) {
              // int to float
              if (srcType.isUnsigned())
                result = convertUnaop(pHir, opName(Op.CONVUF));
              else
                result = convertUnaop(pHir, opName(Op.CONVSF));
            } else {
              // int to int
              int d = type.getSizeValue() - srcType.getSizeValue();
              if (d > 0) {
				// extend
                if (srcType.isUnsigned())
                  result = convertUnaop(pHir, opName(Op.CONVZX));
                else
                  result = convertUnaop(pHir, opName(Op.CONVSX));
              } else if (d < 0)
                result = convertUnaop(pHir, opName(Op.CONVIT));
              else
                result = convertNode((HIR)pHir.getChild1()); // do nothing
            }
          }
	}
        return result;

      case HIR.OP_CONTENTS:
        if (pIsLvalue)
          result = convertNode((HIR)pHir.getChild1());
        else {
	  
	  ImList tmp = convertNode((HIR)pHir.getChild1());
	  
	  if (isVolatile) {
	    result = memExp(htype2ltype(pHir.getType()), tmp, "&V");
	  } else {
	    result = memExp(htype2ltype(pHir.getType()), tmp);
	  }
        }
        return result;

      case HIR.OP_SUBS:
	{
	  ImList l = convertLvalue((HIR)pHir.getChild1());
	  ImList r = convertNode((HIR)pHir.getChild2());

	  result = address(l, r);
	  result = pIsLvalue ? result : memExp(ltype, result);
	}
        return result;

      case HIR.OP_ADDR:
      case HIR.OP_DECAY:
        return convertLvalue((HIR)pHir.getChild1());

      case HIR.OP_UNDECAY: convertUnaop(pHir, "##UNDECAY"); return null;
	// todo: UNDECAY may not be appeared in HirC ...

      case HIR.OP_QUAL:
	{
	  ImList l = convertLvalue(((QualifiedExp)pHir).getQualifierExp());
	  
	  result = address(l,
			   intConst(hkind2ltype(Type.KIND_ADDRESS),
				    String.valueOf(((QualifiedExp)pHir).getQualifiedElem().evaluateDisp())));
	  result = pIsLvalue ? result : memExp(ltype, result);
	}
	return result;

      case HIR.OP_ARROW:
	{
	  ImList l = convertNode(((PointedExp)pHir).getPointerExp());

	  result = address(l,
			   intConst(hkind2ltype(Type.KIND_ADDRESS),
				    String.valueOf(((PointedExp)pHir).getPointedElem().evaluateDisp())));
	  result = pIsLvalue ? result : memExp(ltype, result);
	}
	return result;

      case HIR.OP_CALL:
        {
	  if (type.getTypeKind() != Type.KIND_VOID) {
	    // generate temporal.
	    functionVarName = String.valueOf(tempCtr++) + "@functionvalue";
	    // assert ltype != Sym.KIND_SUBP;
	    autoSym = prefix(frameEnt(functionVarName,
				      ltype,
				      String.valueOf(type.getAlignment()),
				      ZERO),
			     autoSym);
	  }
          FunctionExp exp = (FunctionExp)pHir;
          ListIterator params = exp.getParamList().iterator();
          ImList callee = convertNode(exp.getFunctionSpec());
	  ArrayList paramList = new ArrayList();
          while (params.hasNext()) {
            paramList.add(convertNode((HIR)params.next()));
          }
	  ImList tmp = toImList(paramList);
	  ImList out = null;
	  if (type.getTypeKind() != Type.KIND_VOID) {
	    out = list(result = frameExp(ltype, functionVarName));
	  } else {
	    out = result = ImList.Empty;
	  }
	  addLexp(list(opName(Op.CALL), callee, tmp, out));
        }
	//System.out.println("call: " + result);
	result = memExp(ltype, result);
        return result;
	
        // Statements
      case HIR.OP_ASSIGN:
	addLexp(convertBinop(pHir, opName(Op.SET)));
        break;

      case HIR.OP_BLOCK:
        addLexp(convertNode(((BlockStmt)pHir).getFirstStmt()));
        break;

      case HIR.OP_RETURN:
	{
	  if (returnVarName != null) {
	    returnUsed = true;
	    
	    ImList tmp = convertNode(((ReturnStmt)pHir).getReturnValue());
	    //System.out.println("retval; " + tmp);
	    
	    addLexp(list(opName(Op.SET), 
			 ltype,
			 memExp(ltype, frameExp(hkind2ltype(Type.KIND_ADDRESS), returnVarName)),
			 tmp)
		    );
	  }
	  addLexp(
		  list(opName(Op.JUMP),
		       list(opName(Op.LABEL), hkind2ltype(Type.KIND_ADDRESS), _EPILOGUE))
		  );
	}
        break;

      case HIR.OP_IF:
        {
          IfStmt stm = (IfStmt)pHir;
          Label thenlabel = stm.getThenPart().getLabel();
          Label elselabel = stm.getElsePart().getLabel();
          Label endlabel = stm.getEndLabel();
          ImList cond = convertNode(stm.getIfCondition());

	  addLexp(jumpc(cond, thenlabel, elselabel));
          addLexp(convertNode(stm.getThenPart()));
	  addLexp(jump(endlabel));
          addLexp(convertNode(stm.getElsePart()));
          addLexp(convertDeflabel(endlabel));
          break;
        }

      case HIR.OP_WHILE:
        {
          LoopStmt stm = (LoopStmt)pHir;
          Label looplabel = stm.getLoopBackLabel();
          Label endlabel = stm.getLoopEndLabel();
          addLexp(convertDeflabel(looplabel));
          ImList tmp = convertNode(stm.getLoopStartCondition());
	  addLexp(jumpc(tmp, stm.getLoopBodyLabel(), endlabel));
          addLexp(convertNode(stm.getLoopBodyPart()));
          // addLexp(convertDeflabel(stm.getLoopStepLabel()));
	  addLexp(jump(looplabel));
          addLexp(convertDeflabel(endlabel));
        }
        break;

      case HIR.OP_INDEXED_LOOP:
      case HIR.OP_FOR:
        {
          LoopStmt stm = (LoopStmt)pHir;
          Label looplabel = stm.getLoopBackLabel();
          Label endlabel = stm.getLoopEndLabel();
	  addLexp(convertNode(stm.getLoopInitPart()));
          addLexp(convertDeflabel(looplabel));
          if (stm.getLoopStartCondition() != null) {
            ImList tmp = convertNode(stm.getLoopStartCondition());
	    addLexp(jumpc(tmp, stm.getLoopBodyLabel(), endlabel));
          }
          addLexp(convertNode(stm.getLoopBodyPart()));
	  //addLexp(convertDeflabel(stm.getLoopStepLabel()));
	  addLexp(convertNode(stm.getLoopStepPart()));
	  addLexp(jump(looplabel));
	  addLexp(convertDeflabel(endlabel));
        }
        break;
		
      case HIR.OP_UNTIL:
        {
          LoopStmt stm = (LoopStmt)pHir;
          Label looplabel = stm.getLoopBackLabel();
          Label endlabel = stm.getLoopEndLabel();
          addLexp(convertDeflabel(looplabel));
          addLexp(convertNode(stm.getLoopBodyPart()));
          //addLexp(convertDeflabel(stm.getLoopStepLabel()));
          ImList tmp = convertNode(stm.getLoopEndCondition());
	  addLexp(jumpc(tmp, looplabel, endlabel));
          addLexp(convertDeflabel(endlabel));
        }
        break;

      case HIR.OP_LABELED_STMT:
        {
          LabeledStmt stm = (LabeledStmt)pHir;
          ListIterator it = stm.getLabelDefList().iterator();
          while (it.hasNext()) {
	    addLexp(convertDeflabel(((coins.ir.hir.LabelDef)it.next()).getLabel()));
          }
          addLexp(convertNode(stm.getStmt()));
        }
        break;
		
      case HIR.OP_EXP_STMT:
        {
          Exp exp = ((ExpStmt)pHir).getExp();
          if (exp != null) {
	    ImList tmp = convertNode(exp);
	    // value of expStmt must be discard, possibly ...
            // addLexp(tmp);
          }
        }
        break;

      case HIR.OP_JUMP:
	addLexp(jump(((JumpStmt)pHir).getLabel()));
        break;

      case HIR.OP_SWITCH:
        {
          SwitchStmt stm = (SwitchStmt)pHir;
          ImList selExp = convertNode(stm.getSelectionExp());

          ltype = htype2ltype(stm.getSelectionExp().getType());

          int n = stm.getCaseCount();
	  ArrayList caseLab = new ArrayList();
          for (int i = 0; i < n; i++) {
	    caseLab.add(list(intConst(ltype, stm.getCaseConst(i).getName()),
			     labelOperand(stm.getCaseLabel(i))));
          }
          Label defaultlabel = stm.getDefaultLabel();
          
	  ImList tmp = ImList.Empty;
	  for (int i = n - 1; i >= 0; i--) {
	    tmp = prefix(caseLab.get(i), tmp);
	  }
	  tmp = list(tmp, labelOperand(defaultlabel));
	  addLexp(tmp = prefix(opName(Op.JUMPN), selExp, tmp));
	  //System.out.println("labs:" + tmp);
          addLexp(convertNode(stm.getBodyStmt()));
          if (!appearedLabels.contains(defaultlabel)) {
            addLexp(convertDeflabel(defaultlabel));
	  }
          addLexp(convertDeflabel(stm.getEndLabel()));
        }
        break;

      case HIR.OP_SETDATA:	// Fri May  9 20:36:34 JST 2003
	{
	  DZSSeq = new ArrayList();
	  
	  /* prepare lhs */
	  VarNode vnode = null;
	  Type vtype = null;
	  if (pHir.getChild1() instanceof VarNode) {
	    vnode = (VarNode) pHir.getChild1();
	    vtype = vnode.getVar().getSymType();
	    //System.out.println("v.name: " + vnode.getVar().getName());
	    //System.out.println("v.type: " + vtype /*.getTypeKind()*/);
	  } /* todo: else { bug ?} */
	  
	  HIR r = (HIR) pHir.getChild2();
	  
	  // 1. simple constant.
	  if (vtype instanceof BaseType
	      || vtype instanceof PointerType
	      || vtype instanceof EnumType) {
	    if (r instanceof ConstNode) {
	      Const c = ((ConstNode) r).getConstSym();
	      addLbody(list(Keyword.DATA,
			    uniqName(((SymNode) pHir.getChild1()).getSymNodeSym()),
			    list(htype2ltype(vtype), c.toString())));
	    } else {
	      ImList tmp = convertNode1(r, false);
	      addLbody(list(Keyword.DATA,
			    uniqName(((SymNode) pHir.getChild1()).getSymNodeSym()),
			    list(htype2ltype(vtype), tmp)));
	    }
	    break;
	  }
	  
	  // 2. array
	  // (Ltype ...)
	  if (vtype instanceof VectorType) {
	    if (r instanceof ExpListExp) {
	      ExpListExp init = (ExpListExp) r;
	      // overwrite vtype by element type
	      vtype = getVectorElemType((VectorType) vtype);
	      // emit initializer
	      numSeq = new ArrayList();
	      // numSeqType = htype2ltype(vtype); // vector type
	      // ExpList returns no ImList.
	      convertNode1(init, false);
	      ImList tmp = toImList(DZSSeq);
	      addLbody(prefix(Keyword.DATA,
			      uniqName(((SymNode) pHir.getChild1()).getSymNodeSym()),
			      tmp));
	    } else {
	      // char s[] = "string";
	      vtype = getVectorElemType((VectorType) vtype);
	      ImList tmp = convertNode1(r, false);
	      addLbody(list(Keyword.DATA,
			    uniqName(((SymNode) pHir.getChild1()).getSymNodeSym()),
			    tmp));
	      
	    }
	    break;
	  }
	  
	  // 3. struct or union
	  if (vtype instanceof StructType
	      || vtype instanceof UnionType) {
	    if (r instanceof ExpListExp) {
	      ExpListExp init = (ExpListExp) r;
	      numSeq = new ArrayList();
	      //	    numSeqType = null;
	      convertNode1(init, false);
	      ImList tmp = toImList(DZSSeq);
	      //System.out.println("struct-init-top: " + tmp);
	      
	      addLbody(prefix(Keyword.DATA,
			      uniqName(((SymNode) pHir.getChild1()).getSymNodeSym()),
			      tmp));
	    } else {
	      // bug.
	      System.out.println("bug: struion init.");
	    }
	    break;
	  }
	  // 4. others ... bug ?
	  {
	    convertNode1(r, false);
	  }
	}
	break;
	
      case HIR.OP_EXPLIST:
	/* Thu May 15 16:26:46 JST 2003 */
	//System.out.println("explist:" + pHir);
	if (pHir instanceof ExpListExp) {
	  ExpListExp l = (ExpListExp) pHir;
	  int len = l.length();
	  Type ty = l.getType();
	  if (ty instanceof VectorType) {
	    VectorType vty = (VectorType) ty;
	    Type oldNumSeqType = numSeqType; // push numSeqType
	    numSeqType = getVectorElemType(vty);
	    int vlen = vty.getElemCount();
	    //System.out.println("len: " + len + " vlen :" + vlen);
	    for (int i = 0; i < vlen; i++) {
	      if (i < len) {
		//System.out.print(" i = " + i);
		ImList tmp = convertNode1(l.get(i), false);
		if (tmp != null) {
		  numSeq.add(tmp);
		}
	      } /* else do nothing */
	    }
	    // promote to DZSSeq
	    if (numSeq.size() > 0) {
	      ImList tmp = toImList(numSeq);
	      DZSSeq.add(prefix(htype2ltype(numSeqType), tmp));
	      numSeq.clear();
	    }
	    numSeqType = oldNumSeqType; // pop numSeqType
	  } else if (ty instanceof StructType
		     || ty instanceof UnionType) {
	    IrList elem = ty.getElemList();
	    Type oldNumSeqType = numSeqType; // push numSeqType
	    numSeqType = null;
	    for (int i = 0; i < elem.size(); i++) {
	      ImList tmp = convertNode1(l.get(i), false);
	      if (tmp != null) {
		DZSSeq.add(list(htype2ltype(((Sym) elem.get(i)).getSymType()), tmp));
	      }
	    }
	    // promote to DZSSeq
	    if (numSeq.size() > 0) {
	      DZSSeq.add(toImList(numSeq));
	      numSeq.clear();
	    }
	    numSeqType = oldNumSeqType; // pop numSeqType
	  }
	} else {
	  // bad list ?
	}
	break;

      case HIR.OP_EXPREPEAT:
	/* Mon May 19 14:15:15 JST 2003 */
	// CAUTION: We assume floating point zero is represented by
	// all 0 bits.
	{
	  Const n = ((ConstNode) pHir.getChild2()).getConstSym();
	  HIR exp = (HIR) pHir.getChild1();
	  if (exp instanceof ConstNode) {
	    Const c = ((ConstNode) exp).getConstSym();
	    if ((exp.getType().isFloating() && c.doubleValue() == 0.0)
		|| (!exp.getType().isFloating() && c.longValue() == 0)) {
	      // c == 0, emit (ZEROS n)
	      if (numSeq.size() > 0) {
		// promote to DZSSeq
		ImList tmp = toImList(numSeq);
		DZSSeq.add(prefix(htype2ltype(numSeqType), tmp));
		numSeq.clear(); // oder: numSeq = new ArrayList();
	      }
	      ImList tmp;
	      // DO NOT USE exp.getType().getSizeValue() here.
	      DZSSeq.add(tmp = list((Keyword.ZEROS), 
				    String.valueOf(n.longValue() * numSeqType.getSizeValue())));
	      //System.out.println("ZEROS: " + tmp); 
	      break;
	    }
	    // else c != 0, go ahead.
	  }
	  // repeat n times
	  long repCount = n.longValue();
	  for (int i = 0; i < repCount; i++) {
	    numSeq.add(convertNode1(exp, false));
	  }
	  if (numSeq.size() > 0) {
	    // promote to DZSSeq
	    ImList tmp = toImList(numSeq);
	    DZSSeq.add(prefix(htype2ltype(numSeqType), tmp));
	    numSeq.clear(); // oder: numSeq = new ArrayList();
	  }
	}
	break;

      case HIR.OP_NULL:
      case HIR.OP_PHI:
      default:
	//System.out.println("!!" + pHir.getOperator());
	break;
        /*		
                        default:
                        throw new LIRUnsupportedOperationException(              //(3.31$BDI2C(B)
                        pHIR.toString()+" unsupported" );        //(3.31$BDI2C(B)
        */
      }
      pHir = (HIR)pHir.getNextStmt();
    }
    return null;
  }

  // Get element type of multi-dimensional array.
  private Type getVectorElemType(VectorType pVec)
  {
    Type ty = pVec.getElemType();
    if (ty instanceof VectorType) {
      return getVectorElemType((VectorType) ty);
    }
    return ty;
  }

  // Convert binary operator node
  private ImList convertBinop(HIR pHir, String pOpname)
  {
    ImList l = convertNode((HIR)pHir.getChild1());
    ImList r = convertNode((HIR)pHir.getChild2());
    ImList tmp = list(pOpname, htype2ltype(pHir.getType()), l, r);
    //System.out.println("binop: " + tmp);
    return tmp;
  }

  // Convert unary operator node
  private ImList convertUnaop(HIR pHir, String pOpname) {
    ImList tmp = convertNode((HIR)pHir.getChild1());
    return list(pOpname, htype2ltype(pHir.getType()), tmp);
  }

  // Generate DEFLABEL
  private ImList convertDeflabel(Label pLabel) {
    appearedLabels.add(pLabel);
    return list(opName(Op.DEFLABEL), quote(pLabel.getName()));
  }

  // Return LABEL operand
  private ImList labelOperand(Label pLabel) {
    return list(opName(Op.LABEL), hkind2ltype(Type.KIND_ADDRESS), quote(pLabel.getName()));
  }

  // Construct LIR Sexp.
  private ImList intConst(Object type, Object num) {
    return list(opName(Op.INTCONST), type, num);
  }
  private ImList floatConst(Object type, Object num) {
    return list(opName(Op.FLOATCONST), type, num);
  }
  private ImList frameExp(Object type, String s) {
    return list(opName(Op.FRAME), type, quote(s));
  }
  private ImList frameExp(Object type, QuotedString qs) {
    return list(opName(Op.FRAME), type, qs);
  }
  private ImList memExp(Object type, Object exp) {
    return list(opName(Op.MEM), type, exp);
  }
  private ImList memExp(Object type, Object exp, Object m) {
    return list(opName(Op.MEM), type, exp, m);
  }
  private ImList staticExp(String s) {
    //return list(s, opName(Op.STATIC), hkind2ltype(Type.KIND_ADDRESS), s);
    return list(opName(Op.STATIC), hkind2ltype(Type.KIND_ADDRESS), quote(s));
  }
  private ImList jump(Label label) {
    return list(opName(Op.JUMP), labelOperand(label));
  }
  private ImList jumpc(Object cond, Label label1, Label label2) {
    return list(opName(Op.JUMPC), cond, labelOperand(label1), labelOperand(label2));
  }
  private ImList address(Object l, Object r) {
    return list(opName(Op.ADD), hkind2ltype(Type.KIND_ADDRESS), l, r);
  }
  private ImList frameEnt(String s, Object type, Object align, Object offset) {
    return list(quote(s), opName(Op.FRAME), type, align, offset);
  }
  private ImList staticEnt(String s, Object type, Object align, QuotedString seg, Object linkage) {
    return list(quote(s), opName(Op.STATIC), type, align, seg, linkage);
  }
  private ImList staticEnt(QuotedString qs, Object type, Object align, QuotedString seg, Object linkage) {
    return list(qs, opName(Op.STATIC), type, align, seg, linkage);
  }
  private ImList strConst(String name, String s) {
    return list(Keyword.DATA, quote(name), charSeq(s));
  }
  private ImList charSeq(String s) {
    ImList tmp = ImList.Empty;
    for (int i = s.length() - 1; i >= 0; i--) {
      tmp = prefix(String.valueOf((int) s.charAt(i)), tmp);
    }
    return prefix("I8", tmp);	// todo: I8???
  }

  // Convert HIR type to LIR type
  private String htype2ltype(Type pType) {
    int pTypeKind = pType.getTypeKind();
    switch (pTypeKind) {
    case Type.KIND_VECTOR:
    case Type.KIND_STRUCT:
    case Type.KIND_UNION:
      return "A" + String.valueOf(pType.getSizeValue() * 8);
    default:
      return hkind2ltype(pTypeKind);
    }
  }

  // Convert HIR type kind to LIR type
  private String hkind2ltype(int pTypeKind)
  {
    if (pTypeKind == Type.KIND_STRING)
      pTypeKind = Type.KIND_ADDRESS;
    switch (pTypeKind) {
    case Type.KIND_UNDEF:
    case Type.KIND_BOOL:
      //	case Type.KIND_S_CHAR:
    case Type.KIND_SHORT:
    case Type.KIND_INT:
    case Type.KIND_LONG:
    case Type.KIND_LONG_LONG:
    case Type.KIND_CHAR:
    case Type.KIND_U_CHAR:
    case Type.KIND_U_SHORT:
    case Type.KIND_U_INT:
    case Type.KIND_U_LONG:
    case Type.KIND_U_LONG_LONG:
    case Type.KIND_ADDRESS:
    case Type.KIND_OFFSET:
    case Type.KIND_ENUM:
    case Type.KIND_POINTER:
      switch (MachineParam.evaluateSize(pTypeKind)) {
      case 1: return "I8";
      case 2: return "I16";
      case 4: return "I32";
      case 8: return "I64";
      case 16: return "I128";
      default:
        // assert(0);
        ;
      }

    case Type.KIND_VOID:
      return "UNKNOWN";

    case Type.KIND_FLOAT:
    case Type.KIND_DOUBLE:
    case Type.KIND_LONG_DOUBLE:
      switch (MachineParam.evaluateSize(pTypeKind)) {
      case 4:  return "F32";
      case 8:  return "F64";
      case 16: return "F128";
      default:
        // assert(0);
        ;
      }

    case Type.KIND_STRING:
    case Type.KIND_STRUCT:
    case Type.KIND_UNION:
    case Type.KIND_DEFINED:
    case Type.KIND_SUBP:
      return "AGGREGATE";
    }

    return "UNKNOWN";
  }


  // Print Quoted String
  private void printQuotedString(String s)
  {
    int n = s.length();
    StringBuffer buf = new StringBuffer();
    buf.append('"');
    for (int i = 0; i < n; i++) {
      char c = s.charAt(i);
      if (' ' <= c && c <= '~')
        buf.append(c);
      else if (c == '\n')
        buf.append("\\n");
      else if (c == '\t')
        buf.append("\\t");
      else {
        buf.append('\\');
        String v = "00" + Integer.toOctalString((int)c);
        int k = v.length();
        buf.append(v.substring(k - 3));
      }
    }
    buf.append('"');
  }

  // Assign a number to the Symbol pSym
  private Integer numberingSym(Sym pSym)
  {
    Integer varnum = new Integer(tempCtr++);
    symNumbers.put(pSym, varnum);
    return varnum;
  }
}



/*
 * todo list:
 *  x CALL $B$rFHN)$7$?%9%F!<%H%a%s%H$K(B
 *  x $B=i4|2=(B
 *  - $B9=B$BN$N(Bbitfield
 *  - UNDECAY
 */

