
import java.lang.*;
import java.io.*;
import coins.backend.*;
import coins.backend.ana.*;
import coins.backend.opt.*;
import coins.backend.util.*;

/**
 * Back end of COINS compiler
 */
class BackEnd extends Object {

  static final String TMDFILE = "/proj/lang/coins/BackEnd/coins/backend/tmd/test.tmd";

  public static void main(String[] args) throws IOException {
    boolean doCodeGen = false;

    // Check options
    int ai = 0;
    while (ai < args.length) {
      if (args[ai].equals("-g")) {
        doCodeGen = true;
        ai++;
      }
      else
        break;
    }
    if (ai + 1 != args.length) {
      System.err.println("java BackEnd lirfile");
      return;
    }

    PushbackReader stdin
      = new PushbackReader(new InputStreamReader(new FileInputStream(args[ai])));
    PrintWriter stdout = new PrintWriter(System.out, true);
    Object sexp;

    try {
      while ((sexp = ImList.readSexp(stdin)) != null) {
        // System.err.println(sexp.toString());
        // Read LIR
        Module compileUnit = new Module(sexp, stdout);

        // Apply analyses
        compileUnit.apply(Dominators.analyzer);
        compileUnit.apply(DominanceFrontiers.analyzer);

        if (Debug.dumpModule)
          compileUnit.printIt(stdout,
               new LocalAnalyzer[]{Dominators.analyzer,
                                   DominanceFrontiers.analyzer});

        // Apply optimization
        compileUnit.apply(new IntroVirReg(stdout));
        if (Debug.dumpModule) {
          stdout.println();
          stdout.println("After Virtual Register Replacement:");
          compileUnit.printIt(stdout);
        }

        compileUnit.apply(new JumpOpt(stdout));
        compileUnit.apply(new PreHeaders(stdout));
        if (Debug.dumpModule) {
          stdout.println();
          stdout.println("After Jump Optimization, Preheaders Insertion:");
          compileUnit.printIt(stdout,
                              new LocalAnalyzer[]{Dominators.analyzer,
                                                  DominanceFrontiers.analyzer,
                                                  LoopAnalysis.analyzer});
        }

        if (doCodeGen) {
          // Instruction Selection, Register Allocation, Generate Code
          compileUnit.generateCode(stdout, TMDFILE);
        } else {
          compileUnit.apply(new Ssa(stdout));
          if (Debug.dumpModule) {
            stdout.println();
            stdout.println("After Transformation to SSA:");
            compileUnit.printIt(stdout);

            stdout.println();
            stdout.println("After Live Variable Analysis");
            compileUnit.printIt(stdout,
                                new LocalAnalyzer[] {
                                  LiveVariableAnalysis.analyzer,
                                  InterferenceGraph.analyzer});
          }
        }

      }
    } catch (SyntaxError e) {
      throw new RuntimeException("Syntax error: " + e.getMessage());
    }
  }
}
