package coins.backend;

import java.lang.*;
import java.io.*;
import java.util.*;
import coins.backend.*;
import coins.backend.tmd.*;
import coins.backend.sym.*;
import coins.backend.lir.*;
import coins.backend.util.*;
import coins.backend.opt.*;


// Generate Assembly Language.
public class GenCode {

  /** Class without instances **/
  private GenCode() {}

  /** Code generation (including machine-dependent optimization) */
  public static Function doFunction(Function func, TMD rule, PrintWriter debOut) {

    for (;;) {
      // Instruction selection (or re-selection).
      func = func.doInstSel(rule);

      debOut.println("After instsel & reloaded:");
      func.printIt(debOut);

      // allocate registers.
      if (doRegalo(func))
        break;

      // unssa
    }

    return func;
  }


  private static boolean doRegalo(Function func, debOut) {
    // 1. SSA$B$KJQ49!#(B
    func.apply(new Ssa(debOut));

    // 2. Live Variable Analysis $B$r9T$&!#(B
    LiveVariableAnalysis liveInfo
      = (LiveVariableAnalysis)func.require(LiveVariableAnalysis.analyzer);

    // 3. pruned-SSA$B$KJQ49(B(dead $B&U(B-function$B$r:o=|$9$k(B)
    for (BiLink p = func.flowGraph.basicBlkList.first(); !p.atEnd(); p = p.next()) {
      BasicBlk blk = (BasicBlk)p.elem();

      for (BiLink q = blk.instrList().first(); !q.atEnd(); ) {
        LirNode ins = (LirNode)q.elem();
        BiLink next = q.next();

        if (ins.opCode == Op.PHI) {
          if (!liveInfo.isLiveAtEntry(((LirSymRef)ins.src(0)).symbol, blk))
            q.remove();
        }
        q = next;
      }
    }

    // 4. interference graph$B$r:n@.(B
    InterferenceGraph ig
      = (InterferenceGraph)function.require(InterferenceGraph.analyzer);
    
    // 5. coloring

    return true;
  }

}
