package coins.backend;

import java.util.*;
import java.io.*;

import coins.backend.cfg.*;
import coins.backend.lir.*;

/** Interface for result of function analysis. */
public interface LocalAnalysis {

  /** Return true if this analysis is up to date. */
  boolean isUpToDate();

  /** Print result of analysis (OBSOLETED - use printAfterFunction) */
  void printIt(PrintWriter output);

  /** Callback entries for debugging */

  /** Debug print Called before function body. **/
  void printBeforeFunction(PrintWriter output);

  /** Called before each Basic Block. */
  void printBeforeBlock(BasicBlk blk, PrintWriter output);

  /** Called after each Basic Block. */
  void printAfterBlock(BasicBlk blk, PrintWriter output);

  /** Called before each statement. **/
  void printBeforeStmt(LirNode stmt, PrintWriter output);

  /** Called after each statement. **/
  void printAfterStmt(LirNode stmt, PrintWriter output);

  /** Called after function body. **/
  void printAfterFunction(PrintWriter output);
}
