package coins.backend;

import java.lang.*;
import java.io.*;
import java.util.*;
import coins.backend.*;
import coins.backend.tmd.*;
import coins.backend.sym.*;
import coins.backend.lir.*;
import coins.backend.util.*;

/**
 * Represent module, the whole input of the compiler.
 */
public class Module {
  /** Module name */
  public final String name;

  /** Global symbol table */
  public final SymTab globalSymtab = new SymTab();

  /** List of functions */
  public final BiList functionList = new BiList();

  // /** Global symbol reference node's serial number */
  // private int idCounter = 1;

  private PrintWriter debOut;

  /** Create a module */
  public Module(Object sexp, PrintWriter output) throws SyntaxError {
    debOut = output;
    if (!(sexp instanceof ImList))
      throw new SyntaxError("Expected (");
    // output.println("Module:doCodegen() sexp = " + (ImList)sexp);
    ImList ptr = (ImList)sexp;
    if (ptr.elem() != Keyword.MODULE)
      throw new SyntaxError("Expected MODULE");
    if ((ptr = ptr.next()).atEnd())
      throw new SyntaxError("Expected module name");

    name = (String)ptr.elem();

    // Parse top-level S-expressions
    while (!(ptr = ptr.next()).atEnd()) {
      ImList top = (ImList)ptr.elem();
      String kw = (String)top.elem();
      if (kw == Keyword.SYMTAB)
        doSymtbl(top);
      else if (kw == Keyword.DATA)
        doData(top);
      else if (kw == Keyword.FUNCTION) {
        Function f = new Function(this, top, output);
        functionList.add(f);
        if (Debug.dumpFunction) {
          output.println("After CFG created:");
          f.printIt(output);
        }
      }
      else
        throw new SyntaxError("Unexpected " + kw);
    }
  }

  private void doSymtbl(ImList aTop) throws SyntaxError {

    // Parse symbol table
    while (!(aTop = aTop.next()).atEnd()) {
      globalSymtab.addSymbol((ImList)aTop.elem());
    }
  }

  private void doData(ImList aTop) throws SyntaxError {}


  /* LirFactory interface implementation */

  // /** Return upper bound of LirNode id numbers. */
  // public int idBound() { return idCounter; }

  // /** Create STATIC/FRAME/REG node */
  // public LirNode symRef(int opCode, int type, Symbol symbol, ImList opt) {
  // return new LirSymRef(idCounter++, opCode, type, symbol, opt);
  // }

  // /** Create FLOATCONST node */
  // public LirNode fconst(int type, double value, ImList opt) {
  // throw new UnsupportedOperationException();
  // }

  // /** Create INTCONST node */
  // public LirNode iconst(int type, long value, ImList opt) {
  // throw new UnsupportedOperationException();
  // }

  // /** Create SUBREG node */
  // public LirNode subReg(int opCode, int type, LirNode src, int pos, ImList opt) {
  // throw new UnsupportedOperationException();
  // }

  // /** Create LABEL node */
  // public LirNode labelRef(int opCode, int type, Label label, ImList opt) {
  // throw new UnsupportedOperationException();
  // }

  // /** Create unary operator node */
  // public LirNode operator(int opCode, int type, LirNode operand, ImList opt) {
  // throw new UnsupportedOperationException();
  // }

  // /** Create binary operator node */
  // public LirNode operator(int opCode, int type, LirNode operand0, LirNode operand1, ImList opt) {
  // throw new UnsupportedOperationException();
  // }

  // /** Create ternary operator node */
  // public LirNode operator(int opCode, int type, LirNode operand0,
  // LirNode operand1, LirNode operand2, ImList opt) {
  // throw new UnsupportedOperationException();
  // }

  //  /** Create n-ary operator node */
  //  public LirNode operator(int opCode, int type, LirNode operands[], ImList opt) {
  //    throw new UnsupportedOperationException();
  //  }

  //  /** Make a copy of node */
  //  public LirNode makeCopy(LirNode inst) {
  //    throw new UnsupportedOperationException();
  //  }

  /* end LirFactory interface implementation */


  /** Apply some analysis on each function */
  public void apply(LocalAnalyzer analyzer) {
    for (BiLink p = functionList.first(); !p.atEnd(); p = p.next())
      ((Function)p.elem()).apply(analyzer);
  }

  /** Require some analysis for each function */
  public void require(LocalAnalyzer analyzer) {
    for (BiLink p = functionList.first(); !p.atEnd(); p = p.next())
      ((Function)p.elem()).require(analyzer);
  }

  /** Do some transform(or optimization) on each function */
  public void apply(LocalTransform transformer) {
    for (BiLink p = functionList.first(); !p.atEnd(); p = p.next())
      ((Function)p.elem()).apply(transformer);
  }

  /** Code generation */
  public void generateCode(PrintWriter codeFile, String tmdfile)
   throws SyntaxError, IOException {
    // Generate external variables.
    TMD rule = new TMD(tmdfile);

    // Instruction selection, register allocation
    for (BiLink p = functionList.first(); !p.atEnd(); p = p.next()) {
      Function func = (Function)p.elem();
      p.setElem(func.generateCode(rule));
    }

    // asm out
  }



  /** Print current module status */
  public void printIt(PrintWriter out) { printIt(out, null); }

  /** Print current module status with analyses */
  public void printIt(PrintWriter out, LocalAnalyzer[] anals) {
    out.println("Module \"" + name + "\":");
    out.print("Global ");
    globalSymtab.printIt(out);
    for (BiLink p = functionList.first(); !p.atEnd(); p = p.next()) {
      ((Function)p.elem()).printIt(out, anals);
    }
  }
}
