package coins.backend.opt;

import java.io.*;
import java.util.*;
import coins.backend.*;
import coins.backend.util.*;
import coins.backend.lir.*;
import coins.backend.cfg.*;
import coins.backend.sym.*;

/** Virtual Register Replacement */
public class IntroVirReg implements LocalTransform {
  private PrintWriter output;

  public IntroVirReg(PrintWriter out) {
    output = out;
  }

  // ##Should consult TMD##
  private boolean isregistertype(int type) {
    return Type.tag(type) != Type.AGGREGATE;
  }

  public void doIt(Function f) {

    LirVisitor v = new LirVisitor() {
        int lastOp = 0;

        public void visit(LirFconst node) {}
        public void visit(LirIconst node) {}
        public void visit(LirLabelRef node) {}
        public void visit(LirSubReg node) {}

        public void visit(LirSymRef node) {
          if (node.opCode == Op.FRAME) {
            SymAuto sym = (SymAuto)node.symbol;
            if (lastOp != Op.MEM)
              sym.setFlag(Symbol.F_ADDRTAKEN, true);
          }
        }

        public void visit(LirUnaOp node) {
          if (node.opCode == Op.LABEL)
            return;
          lastOp = node.opCode;
          node.src(0).accept(this);
        }

        public void visit(LirBinOp node) {
          lastOp = node.opCode;
          node.src(0).accept(this);
          lastOp = node.opCode;
          node.src(1).accept(this);
        }

        public void visit(LirNaryOp node) {
          int n = node.nSrcs();
          for (int i = 0; i < n; i++) {
            lastOp = node.opCode;
            node.src(i).accept(this);
          }
        }
      };
    
    // Mark address taken variables
    for (BiLink p = f.flowGraph.basicBlkList.first(); !p.atEnd(); p = p.next()) {
      BasicBlk blk = (BasicBlk)p.elem();
      for (BiLink q = blk.instrList().first(); !q.atEnd(); q = q.next()) {
        LirNode stmt = (LirNode)q.elem();
        stmt.accept(v);
      }
    }

    // Allocate virtual registers
    for (Iterator it = f.localSymtab.iterator(); it.hasNext(); ) {
      Symbol var = (Symbol)it.next();
      if (var.storage == Storage.FRAME && !var.testFlag(Symbol.F_ADDRTAKEN)
          && isregistertype(var.type)) {
        String name = (var.name + "%").intern();
        Symbol reg = f.addSymbol(name, Storage.REG, var.type, 0, 0, null);
        var.setShadow(reg);
        reg.setShadow(var);
      }
    }

    // Replace (REG "tXXX") for (MEM (FRAME "xxx"))
    for (BiLink p = f.flowGraph.basicBlkList.first(); !p.atEnd(); p = p.next()) {
      BasicBlk blk = (BasicBlk)p.elem();
      for (BiLink q = blk.instrList().first(); !q.atEnd(); q = q.next()) {
        LirNode stmt = (LirNode)q.elem();
        replaceAll(stmt, f);
      }
    }
  }

  private LirNode replaceAll(LirNode node, Function f) {
    if (node.opCode == Op.LABEL)
      return node;
    if (node.opCode == Op.MEM) {
      LirNode mem = node.src(0);
      if (mem.opCode == Op.FRAME) {
        Symbol var = ((LirSymRef)mem).symbol;
        Symbol reg = var.shadow();
        if (reg != null)
          return f.newLir.symRef(reg);
      }
    }
    int n = node.nSrcs();
    for (int i = 0; i < n; i++) {
      LirNode oldsrc = node.src(i);
      LirNode newsrc = replaceAll(oldsrc, f);
      if (newsrc != oldsrc)
        node.setSrc(i, newsrc);
    }
    return node;
  }


}
