package coins.backend.opt;

import java.io.*;
import java.util.*;
import coins.backend.*;
import coins.backend.util.*;
import coins.backend.lir.*;
import coins.backend.cfg.*;
import coins.backend.sym.*;

/** Remove Jump-only or unreachable blocks.
 *   An example of FlowGraph/BasicBlk transformation. */
public class JumpOpt implements LocalTransform {

  private PrintWriter output;

  public JumpOpt(PrintWriter out) {
    output = out;
  }

  /** Optimize jumps */
  public void doIt(Function f) {
    FlowGraph g = f.flowGraph;

    // Remove blocks with single successor/predecessor. */

    // Find jump-only blocks and get their targets.
    BasicBlk[] go = new BasicBlk[g.idBound()];
    for (BiLink p = g.basicBlkList.first(); !p.atEnd(); p = p.next()) {
      BasicBlk blk = (BasicBlk)p.elem();
      if (!blk.instrList().isEmpty()) {
        LirNode ins = (LirNode)blk.instrList().first().elem();
        if (ins.opCode == Op.JUMP) {
          Label[] targets = ins.getTargets();
          go[blk.id] = targets[0].basicBlk();
        }
      }
    }

    // Convergense
    BasicBlk[] v = g.blkVectorByRPost();

    boolean changed = true;
    while (changed) {
      changed = false;
      for (int i = v.length - 1; i >= 1; i--) {
        BasicBlk target = go[v[i].id];
        if (target != null && go[target.id] != null
            && go[target.id] != target) {
          go[v[i].id] = go[target.id];
          changed = true;
        }
      }
    }

    // Rewrite
    for (int i = 1; i < v.length; i++) {
      if (go[v[i].id] != null)
        v[i].label().setBasicBlk(go[v[i].id]);
    }

    for (int i = 1; i < v.length; i++)
      v[i].maintEdges();

    g.dfstOrder();

    // Remove unreachable block
    for (BiLink p = g.basicBlkList.first(); !p.atEnd(); ) {
      BasicBlk blk = (BasicBlk)p.elem();
      BiLink next = p.next();
      if (blk.dfn() == 0) {
        // Unreachable block, remove it
        blk.clearEdges();
        p.unlink();
      }
      p = next;
    }

    g.touch();
  }
}
