package coins.backend.opt;

import java.io.*;
import java.util.*;
import coins.backend.*;
import coins.backend.util.*;
import coins.backend.cfg.*;
import coins.backend.ana.*;


/** Insert pre-headers above loops. */
public class PreHeaders implements LocalTransform {
  private PrintWriter output;

  public PreHeaders(PrintWriter out) {
    output = out;
  }

  /** Insert pre-headers above reducible loops. */
  public void doIt(Function f) {
    LoopAnalysis loop = (LoopAnalysis)f.require(LoopAnalysis.analyzer);

    for (BiLink p = f.flowGraph.basicBlkList.first();
         !p.atEnd(); p = p.next()) {
      BasicBlk entry = (BasicBlk)p.elem();

      // Is block 'entry' is the entry of a loop which is reducible?
      if (loop.isLoop[entry.id] && !loop.multiEntry[entry.id]) {
        BasicBlk preHeader = f.flowGraph.insertNewBlkBefore(entry);

        // Rewrite edges go to entry only those not come from inside of the loop
        for (BiLink q = entry.predList().first(); !q.atEnd(); q = q.next()) {
          BasicBlk pred = (BasicBlk)q.elem();
          if (pred != preHeader && !entry.isAncestorOf(pred))
            pred.replaceSucc(entry, preHeader);
        }
      }
    }
  }

}
