// 

package coins.backend.tmd;

import java.io.*;
import coins.backend.tmd.cs.*;

public class LibLisp {
  static void init(){}

  static { Subr.def("LibLisp", "identity", 1); }
  public static Object identity(Object x) {
    return x;
  }

  static { Subr.def("LibLisp", "reads", 1); }
  public static Object reads(String str) {
    // $BJ8;zNs$+$i(B S $B<0$rFI$`!#(B
    Object val = null;
    try {
      PushbackReader in = IO.openInputString(str);
      val = IO.read(in);
      in.close();
    } catch (IOException x) {}
    return val;
  }

  static { Subr.def("LibLisp", "evals", 1); }
  public static Object evals(String str) {
    // $BJ8;zNs$+$i(B S $B<0$rFI$_!"I>2A!#(B
    return Eval.topLevelEval(reads(str));
  }

  static { Subr.def("LibLisp", "readf", 1); }
  public static Object readf(String file) throws IOException {
    // $B%U%!%$%k$+$i(B S $B<0$rFI$`!#(B
    PushbackReader in = IO.openInputFile(file,"JISAutoDetect");
    Object val = IO.read(in);
    in.close();
    return val;
  }

  static { Subr.def("LibLisp", "writef", 2); }
  public static Object writef(String file, Object x) throws IOException {
    // $B%U%!%$%k$K(B S $B<0$r=q$/!#(B
    Writer out = IO.openOutputFile(file, null);
    IO.write(x, out);
    out.close();
    return x;
  }

  static { Subr.defSpecial("LibLisp", "Lwhile", "while", 1, 0, true); }
  public static Object Lwhile(Object cond, List body, Env env) {
    // Emacs Lisp $B$N(B while
    while (Eval.eval(cond, env) != Boolean.FALSE) {
      for (List b = body; b != List.nil; b = (List) b.cdr)
	Eval.eval(b.car, env);
    }
    return List.nil;
  }

  static { Subr.defSpecial("LibLisp", "dolist", 1, 0, true); }
  public static Object dolist(Pair iter, List body, Env env) {
    // Common Lisp $B$N(B dolist
    Symbol var = (Symbol)iter.car;
    List list = (List)Eval.eval(((Pair)iter.cdr).car, env);
    Object ret = ((Pair)iter.cdr).cdr;
    Env newenv = new Env(var, List.nil, env);
    if (ret != List.nil)
      ret = ((Pair)ret).car;
    for (; list != List.nil; list = (List)list.cdr) {
      Env.recBind1(list.car, newenv);
      for (List bs = body; bs != List.nil; bs = (List)bs.cdr) {
	Eval.eval(bs.car, newenv);
      }
    }
    return Eval.eval(ret, env);
  }

  static { Subr.defSpecial("LibLisp", "dolistA", "dolist*", 1, 0, true); }
  public static Object dolistA(Pair iter, List body, Env env) {
    // $BJQ?t$O(B nthcdr $B$K%P%$%s%I$5$l!"%k!<%W!#(B
    Symbol var = (Symbol)iter.car;
    List list = (List)Eval.eval(((Pair)iter.cdr).car, env);
    Object ret = ((Pair)iter.cdr).cdr;
    Env newenv = new Env(var, List.nil, env);
    if (ret != List.nil)
      ret = ((Pair)ret).car;
    for (; list != List.nil; list = (List)list.cdr) {
      Env.recBind1(list, newenv);
      for (List bs = body; bs != List.nil; bs = (List)bs.cdr) {
	Eval.eval(bs.car, newenv);
      }
    }
    return Eval.eval(ret, env);
  }

  static { Subr.defSpecial("LibLisp", "dotimes", 1, 0, true); }
  public static Object dotimes(Pair iter, List body, Env env) {
    // Common Lisp $B$N(B dotimes
    Symbol var = (Symbol)iter.car;
    Number num = (Number)Eval.eval(((Pair)iter.cdr).car, env);
    Object ret = ((Pair)iter.cdr).cdr;
    Env newenv = new Env(var, List.nil, env);
    if (ret != List.nil)
      ret = ((Pair)ret).car;
    
    for (Number i = Num.makeInt(0); Num.compare(i,num)<0; i = Num.onePlus(i)) {
      Env.recBind1(i, newenv);
      for (List bs = body; bs != List.nil; bs = (List)bs.cdr) {
	Eval.eval(bs.car, newenv);
      }
    }
    return Eval.eval(ret, env);
  }

  static { Subr.def("LibLisp", "sort_list", "sort-list!", 2); }
  public static List sort_list(List x, Function lessp) {
    return sort_list_aux(x, LibFun.length(x), lessp);
  }

  private static List sort_list_aux(List x, int len, Function lessp) {
    if (len <= 1)
      return x;
    int ll = len/2;
    List xl = x;
    x = (List)List.nthcdr(ll-1, x);
    List xr = (List)x.cdr;
    x.cdr = List.nil;
    xl = sort_list_aux(xl, ll, lessp);
    xr = sort_list_aux(xr, len-ll, lessp);
    return merge_list(xl, xr, lessp);
  }

  static { Subr.def("LibLisp", "merge_list", "merge-list!", 3); }
  public static List merge_list(List x, List y, Function lessp) {
    List ret = LibFun.list(List.nil);
    List tail = ret;
    List arg2 = LibFun.list(List.nil, List.nil);
    while (true) {
      if (x == List.nil) { tail.cdr = y; break; }
      if (y == List.nil) { tail.cdr = x; break; }
      arg2.car = y.car;
      ((List)arg2.cdr).car = x.car;
      if (lessp.invoke(arg2) != Boolean.FALSE) {
	tail.cdr = y;
	tail = y;
	y = (List)y.cdr;
      }
      else {
	tail.cdr = x;
	tail = x;
	x = (List)x.cdr;
      }
    }
    return (List)ret.cdr;
  }

  static { Subr.def("LibLisp", "copy_list", "copy-list", 1); }
  public static List copy_list(List x) {
    Tconc tc = new Tconc();
    while (x != List.nil) {
      tc.tconc(x.car);
      x = (List)x.cdr;
    }
    return tc.toList();
  }

  static { Subr.def("LibLisp", "symbol_lessp", "symbol<?", 2); }
  public static Boolean symbol_lessp(Symbol s1, Symbol s2) {
    return s1.toString().compareTo(s2.toString()) < 0
      ? Boolean.TRUE : Boolean.FALSE;
  }

  static { Subr.def("LibLisp", "runtime_exception", "runtime-exception", 1); }
  public static Object runtime_exception(String msg) {
    throw Eval.error(msg);
  }
  

  /*
  static final Subr lessp = Subr.make("LibLisp", "symbol_lessp", 2);
  static { Subr.def("LibLisp", "sort_symbol_list", "sort-symbol-list!", 1); }
  public static List sort_symbol_list(List sl) {
  return sort_list(sl, lessp);
  }
  */

  static { Subr.def("LibLisp", "eval", 1); }
  public static Object eval(Object expr) {
    return Eval.topLevelEval(expr);
  }

  static { Subr.defSpecial("LibLisp", "when", 1, 0, true); }
  public static Object when(Object expr, List body, Env env) {
    if (Eval.eval(expr, env) != Boolean.FALSE) {
      for (List b = body; b != List.nil; b = (List) b.cdr)
	Eval.eval(b.car, env);
    }
    return List.nil;
  }

  static { Subr.defSpecial("LibLisp", "unless", 1, 0, true); }
  public static Object unless(Object expr, List body, Env env) {
    if (Eval.eval(expr, env) == Boolean.FALSE) {
      for (List b = body; b != List.nil; b = (List) b.cdr)
	Eval.eval(b.car, env);
    }
    return List.nil;
  }

  static { Subr.defSpecial("LibLisp", "incf", "inc!", 1, 1, false); }
  public static Number incf(Symbol sym, Object num, Env env) {
    return (Number)Env.vset(sym,
			    LibFun.add((Number)Env.vref(sym, env),
				       num == null ?
				         Num.makeInt(1)
				       : (Number)Eval.eval(num, env)),
			    env);
  }

  static { Subr.defSpecial("LibLisp", "decf", "dec!", 1, 1, false); }
  public static Number decf(Symbol sym, Object num, Env env) {
    return (Number)Env.vset(sym,
			    LibFun.sub((Number)Env.vref(sym, env),
				       num == null ?
				         Num.makeInt(1)
				       : (Number)Eval.eval(num, env)),
			    env);
  }

}
