// Que $B$N(B Lisp $BMQ%$%s%?%U%'!<%9(B

package coins.backend.tmd;

import coins.backend.tmd.cs.*;

public class QueLisp {
  public static void init(){}

  // $B%3%s%9%H%i%/%?!#(B
  
  static { Subr.def("QueLisp", "LQue", "make-que", 0, 1); }
  public static Que LQue(Object d) {
    return new Que(d == null ? List.nil : d);
  }

  // $B%"%/%;%94X?t!#(B

  static { Subr.def("QueLisp", "que_next", "que-next", 1); }
  public static Que que_next(Que q) {
    return q.next;
  }

  static { Subr.def("QueLisp", "que_prev", "que-prev", 1); }
  public static Que que_prev(Que q) {
    return q.prev;
  }

  static { Subr.def("QueLisp", "que_data", "que-data", 1); }
  public static Object que_data(Que q) {
    return q.data;
  }

  static { Subr.def("QueLisp", "set_que_next", "set-que-next!", 2); }
  public static Que set_que_next(Que q, Que n) {
    return q.next = n;
  }

  static { Subr.def("QueLisp", "set_que_prev", "set-que-prev!", 2); }
  public static Que set_que_prev(Que q, Que p) {
    return q.prev = p;
  }

  static { Subr.def("QueLisp", "set_que_data", "set-que-data!", 2); }
  public static Object set_que_data(Que q, Object d) {
    return q.data = d;
  }

  // $B4pK\A`:n!#(B

  static { Subr.def("QueLisp", "link_que", "link-que", 1, true); }
  public static Object link_que(Que q1, List qs) {
    for (List q = qs; q != List.nil; q = (List)q.cdr)
      q1 = q1.link((Que)q.car);
    return List.nil;
  }

  static { Subr.def("QueLisp", "insert_que", "insert-que", 2); }
  public static Que insert_que(Que q, Object d) {
    // q $B$NA0$KA^F~!#(Bq $B$,%X%C%@$@$i$=$N(B que $B$NKvHx$KA^F~$9$k$3$H$K$J$k!#(B
    return q.insert(d);
  }

  static { Subr.def("QueLisp", "append_que", "append-que", 2); }
  public static Que append_que(Que q, Object d) {
    // q $B$N8e$KA^F~!#(Bq $B$,%X%C%@$@$i$=$N(B que $B$N@hF,$KA^F~$9$k$3$H$K$J$k!#(B
    return q.append(d);
  }

  static { Subr.def("QueLisp", "delete_que", "delete-que", 1); }
  public static Que delete_que(Que q) {
    return q.delete();
  }

  // $B%j%9%H$H$NJQ49!#(B

  static { Subr.def("QueLisp", "list2que", "list->que", 1); }
  public static Que list2que(List list) {
    return Que.fromList(list);
  }

  static { Subr.def("QueLisp", "que2list", "que->list", 1); }
  public static List que2list(Que qh) {
    return qh.toList();
  }

  // $B%k!<%W!#(B

  static { Subr.defSpecial("QueLisp", "doque", 1, 0, true); }
  public static Object doque(Pair iter, List body, Env env) {
    // Common Lisp $B$N(B dolist $B$HF1MM!#(B
    Symbol var = (Symbol)iter.car;
    Que qh = (Que)Eval.eval(((Pair)iter.cdr).car, env);
    Object ret = ((Pair)iter.cdr).cdr;
    Env newenv = new Env(var, List.nil, env);
    if (ret != List.nil)
      ret = ((Pair)ret).car;
    for (Que q = qh.next; q != qh; q = q.next) {
      Env.recBind1(q.data, newenv);
      for (List bs = body; bs != List.nil; bs = (List)bs.cdr) {
	Eval.eval(bs.car, newenv);
      }
    }
    return Eval.eval(ret, env);
  }

  static { Subr.defSpecial("QueLisp", "doqueA", "doque*", 1, 0, true); }
  public static Object doqueA(Pair iter, List body, Env env) {
    // data $B$G$J$/(B que $B$NJ}$r%P%$%s%I!#(B
    // $B7+$jJV$7Cf$K!V:#!W$NMWAG$r(B delete-que $B$7$F$b(B OK$B!#(B
    Symbol var = (Symbol)iter.car;
    Que qh = (Que)Eval.eval(((Pair)iter.cdr).car, env);
    Object ret = ((Pair)iter.cdr).cdr;
    Env newenv = new Env(var, List.nil, env);
    if (ret != List.nil)
      ret = ((Pair)ret).car;
    Que next;
    for (Que q = qh.next; q != qh; q = next) {
      next = q.next;
      Env.recBind1(q, newenv);
      for (List bs = body; bs != List.nil; bs = (List)bs.cdr) {
	Eval.eval(bs.car, newenv);
      }
    }
    return Eval.eval(ret, env);
  }


}
