;;;; $BL?NaA*Br!#(B
;;;; TODO: eq, ne $B@)Ls!#(Bjava $B$X$N%3%s%Q%$%k!#(B

(define (instsel lfunc)
  (set! lfunc (copy-sexp lfunc))
  (let ((symtab (caddr lfunc))
	(iexps (cdddr lfunc))
	(oexps (make-tconc)))
    (dolist (iexp iexps)
      (dolist (oexp (instsel-exp iexp symtab))
	(tconc oexps oexp)))
    (set-cdr! (cddr lfunc) (tconc->list oexps))
    lfunc))

(define (test-instsel-exp exp)
  (instsel-exp exp (list 'SYMTAB)))

(define (instsel-exp exp symtab)
  ;; $B$R$H$D$N<0$NL?NaA*Br!#(B
  (if (memq (car exp)
	    '(PROLOGUE EPILOGUE CALL DEFLABEL JUMP JUMPC JUMPN))
      ;; $B$3$l$i$OL$%5%]!<%H(B
      (list exp)
    ;;
    (let ((exp (copy-sexp exp))
	  (exps ()))
      ;;
      (tiling-exp exp)
      (when (memq 'instsel *debug*)
	(print-exp-after-tiling exp))
      ;;
      (set! exps (linearize-tiled-exp exp symtab))
      (when (memq 'instsel *debug*)
	(print-exp-after-linearize exps))
      ;;
      exps)))

;;; $B%l%8%9%?=89g$NDj5A!#(B
;;; (defregset <Symbol> ( {<RegExp>} ))

(define (defregset-load-eval form)
  (put (cadr form) 'regset (caddr form)))

(define (regset-sym? sym)
  (let ((regset (get sym 'regset)))
    (if (null? regset) #f regset)))
  

;;; $B=q$-49$(%k!<%k$N9=J8$*$h$S%m!<%@!#(B

;;; defrule $B$N%7%s%?%C%/%9(B:
;;; 
;;; (defrule < <nt> | (<nt> <name>) >
;;;   <pat>
;;;   [(asm <asmexp>)]
;;;   [(cost <costexp>)]
;;;   [(cond {<conexp>})])
;;;
;;; <nt>, <name> ::= $B%7%s%\%k(B
;;; <pat> ::= L-$B<0(B $B$NItJ,<0$,%7%s%\%k$N(B S-$B<0!#C1$J$k%7%s%\%k$O(B chain rule$B!#(B
;;; <xxxexp> ::= Scheme $B$N<0!"%Q%?!<%s$O(B $n $B$G;2>H!#(B


;;; rule $B$X$N%"%/%;%94X?t!#(B

(define rule-nt caadr)
(define rule-name cadadr)
(define rule-pat caddr)
(define rule-misc cdddr)
(define (rule-asm r) (cadr (or (assq 'asm (rule-misc r)) ())))
(define (rule-cost r) (cadr (assq 'cost (rule-misc r))))
(define (rule-cond r) (cdr (assq 'cond (rule-misc r))))
(define (rule-name->rule sym) (get sym 'rule))


;;; rule $B$N%m!<%I(B
;;; tmd $B%U%!%$%k$+$i(B rule $B$rFI$_9~$`!#(B
;;; *rule-list* $B$KA4(B rule $B$,%m!<%I=g$K5-O?$5$l$k!#(B
;;; *chain-rule-alist* $B$K(B chain rule $B$r$?$I$k$?$a$N(B
;;; $B>pJs$b5-O?$5$l$k!#(B

(define *rule-list* ())
(define *chain-rule-alist* ())

(define *rule-no* 0)

(define (defrule-load-begin)
  (set! *rule-no* 0)
  (set! *rule-list* (make-tconc)))

(define (defrule-load-eval r)
  (tconc *rule-list* (fillup-rule r))
  ;; $B%k!<%kL>$N(B 'rule $BB0@-$K(B r $B$r%;%C%H!#(B
  (put (rule-name r) 'rule r))

(define (defrule-load-end)
  (set! *rule-list* (tconc->list *rule-list*))
  (set! *chain-rule-alist* (make-chain-rule-alist *rule-list*)))

(define (fillup-rule r)
  ;; defrule $B$G$N>JN,!"N,5-ItJ,$r2C$(!"@55,2=$9$k!#(B
  (inc! *rule-no*)
  (when (symbol? (cadr r))
    ;; rule $BL>$,>JN,$5$l$?>l9g$O(B n $BHVL\$N%k!<%k$K$D$$$F(B Rn $B!#(B
    (let ((nt (cadr r)))
      (set-car! (cdr r)
		(list nt (string->symbol (format 0 "R%d" *rule-no*))))))
  (unless (assq 'asm (rule-misc r))
    (nconc r (list (if (chain-rule? r)
		       '(asm $1)
		     `(asm ,(format 0 "** %s has no asm **"
				    (rule-name r)))))))
  (unless (assq 'cost (rule-misc r))
    (nconc r (list '(cost 0))))
  (unless (assq 'cond (rule-misc r))
    (nconc r (list '(cond))))
  r)

(define (chain-rule? rule)
  (symbol? (rule-pat rule)))

(define (make-chain-rule-alist rules)
  ;; non terminal Ni $B$K$D$$$F!"(B
  ;; $B%k!<%k(B R1, R2, ... $B$N(B pat $B$,(B Ni $B$N$H$-!"(B
  ;; ((Ni  R1 R2) ...)
  ;; $B$H$$$&(B A-$B%j%9%H(B $B$r:n$k!#(B
  (let ((alist (make-tconc)))
    (dolist (rule rules)
      (when (chain-rule? rule)
	;; chain rule
	(let* ((n (rule-pat rule))
	       (a (assq n (tconc->list alist))))
	  (unless a
	    (set! a (list n))
	    (tconc alist a))
	  (when (assq (rule-nt rule) (cdr a))
	    (error "duplicated chain rule: %s->%s" (rule-nt rule) n))
	  (nconc a (list rule)))))
    (tconc->list alist)))
  
(define (print-rule-chain-alist)
  (dolist (a *chain-rule-alist*)
    (format 1 "%s  " (car a))
    (dolist (r (cdr a))
      (format 1 " (%s %s)" (car r) (rule-name (cdr r))))
    (format 1 "\n")))

(define (eval-with-$ form vals env . symtab-opt)
  ;; rule $BCf$N(B Scheme $B<0$N(B evaluator$B!#(B
  ;; vals = (v0 v1 ...)
  ;; $i $B$r(B vi $B$K%P%$%s%I$7!"(Benv $B$b2C$($F(B form $B$rI>2A!#(B
  ;; symtab $B$O(B FLAME $B<0$N(B offset $B$rF@$k$N$K;2>H!#(B
  ;;
  ;; (format 1 "???? form=%S  vals=%S\n" form vals)
  (let ((symtab (car symtab-opt)))
    (dotimes (i (length vals))
      (let ((var (string->symbol (format 0 "$%d" i)))
	    (val (car vals)))
	(when (pair? val)
	  (set! val
		(case (car val)
		  ((INTCONST FLOATCONST STATIC LABEL)
		   ;; $B$3$l$i$O$=$NCM!"L>A0$r%P%$%s%I!#(B
		   (caddr val))
		  ((FRAME)
		   ;; $B%*%U%;%C%H$r%P%$%s%I!#(B
		   ;; (sent-offset (symtab-lookup symtab (caddr val)))
		   ;; $B%G%P%C%0$N$?$a!":#$OL>A0$r(B
		   (caddr val))
		  ((REG)
		   ;; $BL>A0$r%P%$%s%I!#!z(Btmd $B$K%U%C%/$rMQ0U!#(B
		   (caddr val))
		  ((SUBREG)
		   ;; $BL>A0$r%P%$%s%I!#!z(Btmd $B$K%U%C%/$rMQ0U!#(B
		   (caddr (caddr val)))
		  (else val)
		  )))
	(set! env (cons `(,var ,val) env))
	(set! vals (cdr vals))))
    (eval-with-env form env)))

(define ($n->n $n)
  (let ((str (symbol->string $n)))
    (string->number (substring str 1 (string-length str)))))


;;; L-$B<0$N%Q%?!<%s%^%C%A!#(B

(define (match-exp-1 exp pat)
  ;; L-$B<0$H(B pat $B$r%^%C%A%s%0$9$k!#(B
  ;; L-$B<0$N$"$k$Y$-$H$3$m$K$"$k%7%s%\%k$r%Q%?!<%s$H8+$J$9!#(B
  ;; $B%Q%?!<%sJQ?t(B vi $B$KBP1~$9$kItJ,<0(B ei $B$N!V>l=j!W$H$N(B alist $B$rJV$9!#(B
  ;; $B$3$3$G!">l=j$H$O$=$NItJ,<0$r(B car $B$GJ];}$7$F$$$k%3%s%9%;%k$G$"$k!#(B
  ;; $B%^%C%A$7$J$$>l9g$O(B #f $B$rJV$9!#(B
  (call/cc
   (lambda (nomatch)
     (nreverse ; patvar $B$,=P8==g$K8=$l$k$h$&$K$9$k!#(B
      (match-typed-exp (list exp) pat () nomatch)))))

(define (match-typed-exp expplace pat alist nomatch)
  (let ((exp (car expplace)))
    (if (symbol? pat)
	(cons (cons pat expplace) alist)
      (let ((code (car pat))
	    (type (cadr pat))
	    (args (cddr pat)))
	(if (and (eq? (exp-code exp) code)
		 (eq? (exp-type exp) type))
	    (if (atomic-typed-exp? exp)
		;; atomic $B$J$i(B code $B$H7?$N$_$G%^%C%A$H$9$k!#(B
		alist
	      (begin
		(foreach-exp-args*
		 (lambda (ep)
		   (set! alist (match-typed-exp ep (car args) alist nomatch))
		   (set! args (cdr args)))
		 exp)
		alist))
	  (nomatch #f))))))

;; (define *exp1* '(SET I32 (MEM I32 (FRAME I32 "i"))
;;                      (ADD I32 (CONVSX I32 (MEM I8 (FRAME I32 "c")))
;;                           (INTCONST I32 4))))
;; 
;; (define *pat1* '(SET I32 (MEM I32 x)
;;                      (ADD I32 (CONVSX I32 reg)
;;                           abcd)))

(define (test-match-exp-1 exp pat)
  ;; $B%^%C%A$N%F%9%H!#(B
  (let ((alist (match-exp-1 exp pat)))
    (if alist
	(dolist (nx alist)
	  (format 1 "%-5S = %S\n" (car nx) (cadr nx)))
      (format 1 "nomatch"))))



;;; Tiling $B%U%'!<%:!#(B
;;;
;;; L-$B<0$r%\%H%`%"%C%W$K(B (DP) $B%^%C%A%s%0$7!"%?%$%k$H$7$F>pJs$r5-O?!#(B
;;; $B$R$H$D$N%?%$%k$O%k!<%k!"N_@Q%3%9%H!":GE,$H$7$FA*$P$l$?$+$I$&$+(B
;;; $B$N>pJs$r$b$D!#(B

(define (make-tile rule cost) (list rule cost))
(define tile-rule car)
(define tile-cost cadr)
(define (tile-set! l r c) (set-car! l r) (set-car! (cdr l) c))
(define (tile-nt l) (rule-nt (tile-rule l)))

(define (print-tile sm tile)
  (format sm "%c %d, %s: %S  ; %S\n"
	  (if (has-prop? tile '&selected) #\* #\space)
	  (tile-cost tile)
	  (tile-nt tile)
	  (rule-pat (tile-rule tile))
	  (rule-name (tile-rule tile))))

;;; $B2DG=$J%?%$%k$N%j%9%H$,(B &tiles $BB0@-$H$7$F(B L-$B<0$K5-O?$5$l$k!#(B
(define (put-exp-tiles exp tiles) (put-prop exp '&tiles tiles))
(define (get-exp-tiles exp) (get-prop exp '&tiles))
(define (rem-exp-tiles exp) (rem-prop exp '&tiles))

(define (print-exp-after-tiling exp)
  (format 1 "*** after tiling:\n")
  (print-tree 1
	      exp
	      exp-args
	      (lambda (sm exp)
		(format sm "%s %s" (exp-code exp) (exp-type exp))
		(when (atomic-typed-exp? exp)
		  (format sm " %S" (exp-atomic-typed-arg exp)))
		(format sm "\n")
		(dolist (l (get-exp-tiles exp))
		  (print-tile sm l)))))


(define (exp-tile exp nt)
  ;; $B%?%$%k$N%j%9%H$+$i(B nt $B$r(B nonterminal $B$H$9$k(B tile $B$rC5$9!#(B
  ;; $B$J$1$l$P(B #f
  (find (lambda (l) (eq? nt (tile-nt l))) (get-exp-tiles exp)))

(define (exp-rule exp nt)
  (tile-rule (exp-tile exp nt)))

(define (exp-match-alist exp nt)
  (match-exp-1 exp (rule-pat (tile-rule (exp-tile exp nt)))))


(define (tiling-exp exp)
  ;; tiling $B$N%H%C%W%l%Y%k!#(B
  ;; $B$R$H$D$N(B L-$B<0(B $B$r(B tiling$B!#(B
  (tiling-typed-exp exp)
  (unless (exp-tile exp 'stmt)
    (format 1 "*** TILING FAILED ***\n")
    (print-exp-after-tiling exp)
    (error "tiling failed."))
  ;;
  ;; $B%?%$%j%s%08e!":GE,$HA*Br$5$l$?(B tile $B$K(B &selected #t $B$r(B put$B!#(B
  ;; $B<B$O$3$N%^!<%/$O%G%P%C%0%@%s%W$N$?$a$N$_!#(B
  (tiling-exp-mark-selected exp)
  ;;
  exp)

(define (tiling-exp-mark-selected exp)
  (define (mark exp nt)
    (put-prop (exp-tile exp nt) '&selected #t)
    (dolist (nx (exp-match-alist exp nt))
      (mark (cadr nx) (car nx))))
  (mark exp 'stmt))

(define (untiling-exp exp)
  ;; '&tiles $BB0@-$r%/%j%"!#(B
  (foreach-exp-recursive rem-exp-tiles exp))

(define (tiling-typed-exp exp)
  ;; typed expr $B$N%?%$%j%s%0!#(B
  ;; bottom up $B$K%?%$%j%s%0$r$9$k!#(B
  ;; $B$^$:;R$K$D$$$F!"(B
  (foreach-exp-args tiling-typed-exp exp)
  ;; $B$=$7$F<+J,$N=hM}$r$9$k!#(B
  (put-exp-tiles exp ())
  (tiling-exp-1 exp))

(define (tiling-exp-record exp rule cost)
  ;; exp $B$K?7$?$J(B rule $B$H(B cost $B$r5-O?!#(B
  ;; $B$?$@$7(B cost $B$,4{$K5-O?$5$l$F$$$k%3%9%H0J>e$J$i5-O?$7$J$$!#(B
  ;; $B<B:]$K5-O?(B/$B99?7$5$l$?$+$I$&$+$rJV$9!#(B
  (let ((updated #f)
	(tile (exp-tile exp (rule-nt rule))))
    (if tile
	(when (< cost (tile-cost tile))
	  ;; $B99?7!#(B
	  (tile-set! tile rule cost)
	  (set! updated #t))
      ;; $B?75,!#(B
      (begin
	(put-exp-tiles
	 exp
	 (nconc (get-exp-tiles exp) (list (make-tile rule cost))))
	(set! updated #t)))
    updated))

(define (tiling-exp-1 exp)
  (dolist (rule *rule-list*)
    (unless (symbol? (rule-pat rule))
      (let ((alist (match-exp-1 exp (rule-pat rule))))
	(when alist
	  ;; $B%Q%?!<%s%^%C%A$O@.8y!#(B
	  ;; $B$?$@$7;R$N(B nt $B$N%^%C%A$OL$%A%'%C%/!#(B
	  (call/cc
	   (lambda (nomatch)
	     (let ((cost 0))
	       (unless (integer? cost)
		 ;; cost $B<0(B ($0=exp) $B$rI>2A!#(B
		 ;; $B!z;R$N%^%C%A$N8e$G9T$J$&$Y$-!#(B
		 (set! cost (eval-with-$ cost (list exp) ())))
	       ;; $B;R$N%3%9%H$r2C$($F5-O?!#(B
	       (dolist (nx alist)
		 (let* ((nt1 (car nx))
			(exp1 (cadr nx))
			(tile (exp-tile exp1 nt1)))
		   (unless tile
		     ;; nt1 $B$,%^%C%A$7$J$+$C$?$N$G!"$3$N(B rule $B$OL5;k!#(B
		     (nomatch ()))
		   ;; $B%^%C%A$7$?$N$G%3%9%H$r2C;;!#(B
		   (inc! cost (tile-cost tile))))
	       ;;
	       (inc! cost (tiling-exp-eval-cost exp rule alist))
	       ;;
	       (unless (tiling-exp-cond-ok? exp rule alist)
		 (nomatch ()))
	       ;;
	       ;; $B5-O?!#(B
	       (when (tiling-exp-record exp rule cost)
		 (tile-chain-rules exp (rule-nt rule) () cost))
	       ))))))))


(define (tiling-exp-eval-cost exp rule alist)
  (tiling-exp-eval (rule-cost rule) exp (rule-nt rule) alist ()))
     
(define (tiling-exp-cond-ok? exp rule alist)
  (let ((conds (rule-cond rule)))
    (call/cc
     (lambda (fail)
       (dolist (con conds #t)
	 (unless (tiling-exp-eval con exp (rule-nt rule) alist `((eq ,equal?)))
	   (fail #f)))))))

(define (tiling-exp-eval form exp nt alist env)
  ;; cost $B5Z$S(B cond $B$NI>2A$N2<0L!#(B
  (if (atom? form)
      form
    (let ((vals (map cadr alist)))
      (eval-with-$
       form
       (if (eq? nt 'stmt) vals (cons exp vals))
       env))))


(define (tile-chain-rules exp nt nthistory cost)
  ;; chain $B%k!<%k$N=hM}!#(B
  (unless (memq nt nthistory)
    (let ((chain (assq nt *chain-rule-alist*)))
      ;; chain = ((Ni  R1 R2) ...)
      (when chain
	(dolist (rule (cdr chain))
	  ;; chain rule $B$N%3%9%H$ODj?t$H2>Dj!#(B
	  (let* ((cost1 (+ cost (rule-cost rule)))) 
	    (tiling-exp-record exp rule cost1)
	    (tile-chain-rules exp (rule-nt rule)
			       (cons nt nthistory)
			       cost1)))))))



;;; Linearize $B%U%'!<%:!#(B
;;; 
;;; $B%?%$%j%s%0$5$l!"L?NaNs$KJ,2r$5$l$?ItJ,LZ$rJ,3d$7!"JB$Y$k!#(B
;;; $B$3$3$G!"?7$?$K:n$i$l$?<0(B($B%l%8%9%?%3%T!<(B)$B$OItJ,E*$K%?%$%j%s%0$5$l$F$$$J$$!#(B
;;; $B$3$3$G:FEY%?%$%j%s%0$7$J$*$7$F$bNI$$$,!"$=$l$h$j$b(B &tiles $BB0@-(B
;;; ($B$+$J$j$&$k$5$$(B)$B$r%/%j%"$7!"%l%8%9%?%"%m%1!<%?$KEO$7!"8e$G(B
;;; $B%"%;%s%V%i=PNO%U%'!<%:$G$^$?%?%$%j%s%0$7$J$*$9$3$H$K$9$k!#(B

(define (linearize-tiled-exp exp symtab)
  ;; Linearize $B$7(B exp $B$N%j%9%H$rJV$9!#(B
  (let ((exps (make-tconc)))
    (linearize-tiled-typed-exp exp exps symtab)
    (set! exps (tconc->list exps))
    (for-each untiling-exp exps)
    exps))

(define (linearize-tiled-typed-exp exp exps symtab)
  (if (set-reg-exp? exp)
      ;; reg $B$X$NBeF~$OFCJL!#$3$l$O%H%C%W%l%Y%k$K$N$_$"$i$o$lF@$k!#(B
      (linearize-tiled-typed-exp-setreg exp 'stmt exps symtab)
    ;; $B0lHL$K$O$D$J$.$N(B reg $B$O2<$+$i>e$K%G!<%?$,N.$l$k!#(B
    (begin
      (linearize-tiled-typed-exp-rec exp 'stmt exps symtab)
      (tconc exps exp))))

(define (linearize-tiled-typed-exp-rec exp nt exps symtab)
  ;; $B;R$rE83+$7!"(B
  (let ((alist (exp-match-alist exp nt))
	(eqcon (assq 'eq (rule-cond (exp-rule exp nt)))) ; $B!z$^$@(B
	(n 0))
    (dolist (nx alist)
      ;; (when (and eqcon (= n 0)) (format 1 "eqcon!\n"))
      (unless (and eqcon (= n 0))
	(let ((exp1p (cdr nx)))
	  (set-car! exp1p (linearize-tiled-typed-exp-rec
			   (car exp1p) (car nx) exps symtab))))
      (inc! n))
    ;;
    (when eqcon
      (set-car! (cdr (car alist))
		(copy-sexp (cadr (cadr alist)))))
    ;;
    ;; $B<+J,$N=hM}!#(B
    (cond
     ((regset-sym? nt)
      ;; $B%l%8%9%?!<$X$NBeF~%3!<%I$r=PNO!#(B
      (linearize-tiled-typed-exp-reg exp nt exps symtab))
     ((chain-rule? (exp-rule exp nt))
      ;; $B%A%'%$%s%k!<%k$N>l9g!#(B
      (cadr (car alist)))
     (else
      ;; $B$=$NB>!#(B
      exp))))
   
(define (linearize-tiled-typed-exp-reg exp dest-regset-sym exps symtab)
  (let* ((reg1 (make-vreg-exp (exp-type exp) symtab))
	 (set1 (make-set-exp reg1 exp))
	 (src-regset-sym ()))
    ;; reg1 $B$N(B &regset $BB0@-$r%;%C%H!#(B
    (put-prop (vreg-exp-sent symtab reg1) '&regset dest-regset-sym)
    ;;
    (tconc exps set1)
    ;; $B$b$&0l2s%3%T!<$,I,MW$J>l9g$,$"$k!#(B
    ;; $B!z(B *-regset-sym $B$rHf$Y$k!#(B
    reg1))

(define (linearize-tiled-typed-exp-setreg exp nt exps symtab)
  (let* ((args (exp-args* exp))
	 (reg (car args))
	 (alist (exp-match-alist exp nt))
	 (regp (cdr (car alist))))
    (assert (eq? reg (cadr (car alist))))
    ;; $B$^$:(B reg $B0J30$rIaDL$K=hM}$7!"(B
    (dolist (nx (cdr alist))
      (let ((exp1p (cdr nx)))
	(set-car! exp1p (linearize-tiled-typed-exp-rec
			 (car exp1p) (car nx) exps symtab))))
    ;; reg $B$r?7$?$J2>A[%l%8%9%?(B reg1 $B$GCV$-49$(!"(B
    ;; exp $B!V=PNO8e!W$K(B reg = reg1 $B$r=P$9!#(B
    (let* ((reg1 (make-vreg-exp (exp-type exp) symtab))
	   (set1 (make-set-exp reg reg1)))
      ;;
      ;; reg1 $B$N(B &regset $BB0@-$r%;%C%H!#!z$^$@(B...
      ;;
      (set-car! regp reg1)
      (tconc exps exp)
      ;; $B?7$?$K:n$C$?(B set1 $B$r=PNO!#(B
      (tconc exps set1))))

(define (print-exp-after-linearize exps)
  (format 1 "*** after linearize:\n")
  (dolist (exp exps)
    (format 1 "%S\n" exp))
  (dolist (exp exps)
    (format 1 "\t%s\n" (slir->clir (exp-without-plist exp)))))
