package coins.backend.tmd;

import coins.backend.tmd.cs.*;

class InitFun {
  private static boolean initialized = false;

  static void init() {
    if (! initialized) {
      Eval.init();

      // % ls *Lisp.java | sed  's/java/init();/'
      LibLisp.init();
      TconcLisp.init();
      QueLisp.init();
      
      Subr.init();
      initialized = true;
    }
  }

  static void load(String csfile, boolean verbose) {
    init();
    try {
      if (verbose) System.out.print("Loading "+csfile+" ... ");
      IO.load(csfile,Boolean.FALSE,null);
      if (verbose) System.out.println("done.");
    } catch (Throwable e) {
      LibFun.fatalError(e);
    }
  }

  static void load(String csfile) {
    load(csfile, false);
  }
}
